/*****************************************************************************/
/*									     */
/*				   ICLOG.CC				     */
/*									     */
/* (C) 1995	Ullrich von Bassewitz					     */
/*		Zwehrenbuehlstrasse 33					     */
/*		D-72070 Tuebingen					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include <stdio.h>

#include "strcvt.h"
#include "datetime.h"



/*****************************************************************************/
/*				     Data				     */
/*****************************************************************************/



// Names of the logfiles
String Logfile1 = "outgoing.log";
String Logfile2 = "";
String Logfile3 = "";

// Price of a charge unit
double PricePerUnit = 0.12;



/*****************************************************************************/
/*				     Code				     */
/*****************************************************************************/



static String ExpandName (const String& Filename, const Time& T, unsigned Dev)
// Expand the name to a real file name.
{
    // Expand private escape sequences
    unsigned I = 0;
    unsigned Len = Filename.Len ();
    String S (Len);
    while (I < Len) {

	// Get the next character from the source
	char C = Filename [I++];

	// Look after '%' only if another char follows
	if (C == '%' && I < Len) {

	    C = Filename [I++];
	    switch (C) {

		case 'E':
		    // %E - Insert extension number
		    S += U32Str (Dev+21);
		    break;

		default:
		    S += '%';
		    S += C;
		    break;

	    }

	} else {

	    // Just copy
	    S += C;

	}
    }

    return T.DateTimeStr (S);
}



static void LogMsg (const String& Filename, String Msg, const Time& T, unsigned Dev)
// Log the message to one file
{
    // If the filename is empty, bail out early
    if (Filename.IsEmpty ()) {
	return;
    }

    // Expand the filename.
    String ExpandedName = ExpandName (Filename, T, Dev);

    // Open the file
    FILE* F = fopen (ExpandedName.GetStr (), "a+t");
    if (F == NULL) {
	// Got an error - ignore it
	return;
    }

    // Convert the string to the external charset
    Msg.OutputCvt ();

    // Write the message to the file
    fputs (Msg.GetStr (), F);
    fputc ('\n', F);

    // Close the file
    fclose (F);
}



void LogCall (const String& Msg, const Time& T, unsigned Dev)
// Log a call to all defined logfiles
{
    LogMsg (Logfile1, Msg, T, Dev);
    LogMsg (Logfile2, Msg, T, Dev);
    LogMsg (Logfile3, Msg, T, Dev);
}



