/*
**
** options.c
**
** Copyright (C) 1995-1997 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@thep.physik.uni-mainz.de)
**           Department of Physics
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

/*
#define MESSAGES
*/
#include "message.h"

#include "config.h"
#include "ctype.h"

#include <stdio.h>
#include <stdlib.h>

#include "paths.h"
#include INC_X11(Intrinsic.h)
#include INC_X11(StringDefs.h)
#include INC_X11(Shell.h)
#include INC_XAW(SimpleMenu.h)
#include INC_XAW(SmeBSB.h)
#include "Aaa.h"
#include "Button.h"
#include "FileSel.h"
#include "Ghostview.h"
#include "Frame.h"
#include "MButton.h"
#include "Switch.h"

#include "callbacks.h"
#include "d_memdebug.h"
#include "file.h"
#include "gv.h"
#include "popup_misc.h"
#include "widgets_misc.h"
#include "main_resources.h"
#include "main_globals.h"
#include "misc.h"
#include "note.h"
#include "options.h"
#include "ps.h"
#include "doc_misc.h"

#ifdef VMS
#   define unlink remove
#   include "strcasecmp.h"
#else
#   include <unistd.h>
#endif

#ifndef max
#   define max(a, b)    ((a) > (b) ? (a) : (b))
#endif

/*### Application dependencies ##############################################*/

#define  OPTIONS_TOPLEVEL 	toplevel	/* the Apllication Shell   */
#define  OPTIONS_APPLIC_CONTEXT app_con		/* the Apllication Context */
#define  OPTIONS_POPUP_NAME	"optionPopup"
#define  OPTIONS_POPUP		optionpopup

#define MESSAGE_STRING_LEN 512
#define MAX_RECORD_LENGTH 512
#define MAX_OPTIONS 10

static Widget   optionControl;
static Widget   reverseScrollingToggle,confirmPrintToggle,antialiasToggle;
static Widget   respectDSCToggle,autoCenterToggle,autoResizeToggle;
static Widget   swapLandscapeToggle,miscLabel;
static Widget   mediaLabel,mediaButton,mediaMenu;
static Widget   fmediaLabel,fmediaButton,fmediaMenu;
static Widget   orientLabel,orientButton,orientMenu;
static Widget   forientLabel,forientButton,forientMenu;
static Widget   magLabel,magButton,magMenu;

static Widget   filter,print_command, scratch_dir,default_save_dir,filters,dirs;
static Bool	optionPopupCreated = False;
static Bool	optionPopupVisible = False;

static String orientations[5] = { "Portrait","Landscape","Upside-Down","Seascape", NULL };
static int opt_orientation;
static int opt_pagemedia;

/*###############################################################################
   SaveOptionsToFile(argn,argi,argfi,argi)
   Modify the resource file according to a given array of options.
   Some care is taken to respect the appearance of the resource file.
      argn: number of options to be saved
      argi: argn strings identifying the resources to be modified
      argv: the values given to the resources argi
###############################################################################*/

#   define END_OF_RECORD "\n"

static char* readline(infile,lineP)
  FILE *infile;
  String *lineP;
{
  char tmp[MAX_RECORD_LENGTH];
  char *esc;
  int  multi;

  BEGINMESSAGE(readline)
  while (fgets(tmp,MAX_RECORD_LENGTH,infile)) {
    multi = *lineP ? strlen(*lineP) : 0;
    *lineP = GV_XtRealloc(*lineP,(multi+strlen(tmp)+1)*sizeof(char));
    if (!multi) (*lineP)[0] = '\0';
    strcat(*lineP,tmp);
    multi=0; esc = strrchr(tmp,'\\');
    if (esc && *(esc+1) == '\n') while (esc != tmp && *esc-- == '\\') multi = !multi;
    if (!multi) break;
  }
  ENDMESSAGE(readline)
  return(*lineP);
}

static void writeline(outfile,header,value)
  FILE *outfile;
  String header;
  String value;
{
  int num_nl=0;
  char *line;
  char *nl=value;

  BEGINMESSAGE(writeline)
  while ((nl=strchr(nl,'\n'))) { nl++; num_nl++; }
  line = GV_XtMalloc((strlen(header) + strlen(value) + num_nl*3 + 2)*sizeof(char));
  line[0]='\0';
  strcpy(line,header);
  while (num_nl>=0) {
    if (num_nl>0) {
      nl=strchr(value,'\n');
      *nl++='\0';
    }
    strcat(line,value);
    if (num_nl) {
      value=nl;
      while(isspace(*value)) value++;
      if (*value=='\0') {
	strcat(line,"\n");
	num_nl=0;
      }
      else strcat(line,"\\n\\\n");
    }
    else        strcat(line,"\n");
    INFSMESSAGE(writing,line)
    fputs(line,outfile);
    num_nl--;
    value=nl;
    line[0]='\0';
  }
  GV_XtFree(line);
  ENDMESSAGE(writeline)
}

static void
SaveOptionsToFile(argn,argi,argv)
  int  argn;
  String *argi;
  String *argv;
{
  FILE *tempfile;
  FILE *infile;
  char *tempfilename;
  char errorMessage[MESSAGE_STRING_LEN];

  BEGINMESSAGE(SaveOptionsToFile)
  if (argn == 0) {
     INFMESSAGE(nothing to do)
     ENDMESSAGE(SaveOptionsToFile)
     return;
  }
  else --argn;

  if (!gv_user_defaults_file) {
    sprintf(errorMessage,"Save aborted: \nUndefined destination file.");
    NotePopupShowMessage(errorMessage);
    INFMESSAGE(undefined destination file)
    ENDMESSAGE(SaveOptionsToFile)
    return;
  }
  INFSMESSAGE(trying to write to,gv_user_defaults_file)

  infile=fopen(gv_user_defaults_file,"r"); 
  tempfilename=file_getTmpFilename(gv_user_defaults_file,gv_user_defaults_file);
  INFSMESSAGE(using temporary file,tempfilename)
   
  if (!tempfilename || !(tempfile = fopen(tempfilename,"w"))) {
    sprintf(errorMessage,"Save aborted: \nCannot create temporary file");
    NotePopupShowMessage(errorMessage);
    INFMESSAGE(cannot create temporary file)
    fclose(infile);
    GV_XtFree(tempfilename);
    ENDMESSAGE(SaveOptionsToFile)
    return;
  }

  if (infile) {
    char *tmp;
    char *line=NULL;
    int i,j;
    while (readline(infile,&line)) {
      SMESSAGE(line)
      i=j=0;
      while (i <= argn) {
	if (argi[i][0] != '\0' && !strncmp(line,argi[i],strlen(argi[i]))) {
	  INFSMESSAGE(found:,line)
	  tmp=strchr(line,':')+1;
	  while (isspace(*tmp)) tmp++; *tmp = '\0';
	  writeline(tempfile,line,argv[i]);
          argi[i][0]='\0';
          j=i;
	  while (j<argn) {
	    tmp=argi[j]; argi[j]=argi[j+1]; argi[j+1]=tmp;
	    tmp=argv[j]; argv[j]=argv[j+1]; argv[j+1]=tmp;
	    j++;
	  }
	  j=1;
	  --argn;
	  break;
	}
	else ++i;
      }
      if (!j) fputs(line,tempfile);
      GV_XtFree(line);
      line=NULL;
    }
    fclose(infile);
  }
  if (argn>=0) fputs(END_OF_RECORD,tempfile);
  while (argn >= 0) {
    writeline(tempfile,argi[argn],argv[argn]);
    argn--;
  }
  fclose(tempfile);

  if (rename(tempfilename,gv_user_defaults_file)) {
    sprintf(errorMessage,"Save aborted: \nCannot rename temporary '%s'\n to '%s'",tempfilename,gv_user_defaults_file);
    NotePopupShowMessage(errorMessage);
    unlink(tempfilename);
    GV_XtFree(tempfilename);
    INFMESSAGE(Cannot rename temporary file)
    ENDMESSAGE(SaveOptionsToFile)
    return;
  }
  GV_XtFree(tempfilename);

  ENDMESSAGE(SaveOptionsToFile)
}

/*###############################################################################
   setOptionsAtEntry
###############################################################################*/

static void setOptionsAtEntry()
{
  String s;
  Arg args[2];
  Cardinal n;
  int i;
  char tmp[100];

  BEGINMESSAGE(setOptionsAtEntry)

  widgets_setToggle(antialiasToggle, (app_res.antialias ? 1 : 0));
  widgets_setToggle(confirmPrintToggle, (app_res.confirm_print ? 1 : 0));
  widgets_setToggle(reverseScrollingToggle, (app_res.reverse_scrolling ? 1 : 0));
  widgets_setToggle(respectDSCToggle, (app_res.respect_dsc ? 1 : 0));
  widgets_setToggle(autoCenterToggle, (app_res.auto_center ? 1 : 0));
  widgets_setToggle(autoResizeToggle, (app_res.auto_resize ? 1 : 0));
  widgets_setToggle(swapLandscapeToggle, (gv_swap_landscape ? 1 : 0));

  SMESSAGE(gv_print_command)
  widgets_setText(print_command, gv_print_command);
  SMESSAGE(app_res.scratch_dir)
  widgets_setText(scratch_dir,  app_res.scratch_dir);
  SMESSAGE(app_res.default_save_dir)
  widgets_setText(default_save_dir,  app_res.default_save_dir);
  SMESSAGE(gv_filters)
  widgets_setText(filters,gv_filters);
  SMESSAGE(gv_dirs)
  widgets_setText(dirs,gv_dirs);
  SMESSAGE(gv_filter)
  widgets_setText(filter,gv_filter);

    n=1;
    XtSetArg(args[0], XtNinsertPosition, strlen(gv_print_command));
    XtSetValues(print_command,args,n);
    XtSetArg(args[0], XtNinsertPosition, strlen(app_res.scratch_dir));
    XtSetValues(scratch_dir,args,n);
    XtSetArg(args[0], XtNinsertPosition, strlen(app_res.default_save_dir));
    XtSetValues(default_save_dir,args,n);
    XtSetArg(args[0], XtNinsertPosition, strlen(gv_filters));
    XtSetValues(filters,args,n);
    XtSetArg(args[0], XtNinsertPosition, strlen(gv_dirs));
    XtSetValues(dirs,args,n);
    XtSetArg(args[0], XtNinsertPosition, strlen(gv_filter));
    XtSetValues(filter,args,n);

  s=NULL;
  for (i = 0; papersizes[i].name; i++) {
    if (!strcasecmp(app_res.default_pagemedia,papersizes[i].name))
      s = papersizes[i].name;
  }
  if (!s) s = "Automatic";
                                   n=0;
  XtSetArg(args[n], XtNlabel, s);  n++;
  XtSetValues(mediaButton, args, n);
  opt_pagemedia = doc_convStringToPageMedia(NULL,s);

  s=NULL;
  for (i = 0; papersizes[i].name; i++) {
    if (!strcasecmp(app_res.fallback_pagemedia,papersizes[i].name))
      s = papersizes[i].name;
  }
  if (!s) s = "A4";
                                   n=0;
  XtSetArg(args[n], XtNlabel, s);  n++;
  XtSetValues(fmediaButton, args, n);

  s=NULL;
  for (i = 0; orientations[i]; i++) {
    if (!strcasecmp(app_res.default_orientation,orientations[i]))
      s = orientations[i];
  }
  if (!s) s = "Automatic";
                                   n=0;
  XtSetArg(args[n], XtNlabel, s);  n++;
  XtSetValues(orientButton, args, n);
  opt_orientation = doc_convStringToDocOrient(s);

  s=NULL;
  for (i = 0; orientations[i]; i++) {
    if (!strcasecmp(app_res.fallback_orientation,orientations[i]))
      s = orientations[i];
  }
  if (!s) s = orientations[0];
                                   n=0;
  XtSetArg(args[n], XtNlabel, s);  n++;
  XtSetValues(forientButton, args, n);

  sprintf(tmp,"%d",app_res.magstep);
                                   n=0;
  XtSetArg(args[n], XtNlabel, tmp);  n++;
  XtSetValues(magButton, args, n);

  ENDMESSAGE(setOptionsAtEntry)
}

/*###############################################################################
   changeOptionsAtExit
###############################################################################*/

#define OPTION_LENGTH 255

static void changeOptionsAtExit()
{
   Arg args[5];
   Cardinal n;
   char    *value, *str;
   static Boolean s_print_command = False;
   static Boolean s_scratch_dir =   False;
   static Boolean s_default_save_dir = False;
   static Boolean s_media = False;
   static Boolean s_fmedia = False;
   static Boolean s_orient = False;
   static Boolean s_forient = False;
   Boolean b;
   int i,j,k;
   Boolean redisplay=False;
   Boolean reopen=False;
   char *l;

   BEGINMESSAGE(changeOptionsAtExit)

   app_res.confirm_print = SwitchIsSet(confirmPrintToggle) ? True : False ;
   app_res.reverse_scrolling = SwitchIsSet(reverseScrollingToggle) ? True : False ;
   app_res.auto_center = SwitchIsSet(autoCenterToggle) ? True : False ;

   b = app_res.antialias;
   app_res.antialias = SwitchIsSet(antialiasToggle) ? True : False;
   cb_antialias(NULL,NULL,NULL); /* only change the menu entry */
   if (b != app_res.antialias) reopen=True;

   i = gv_swap_landscape;
   gv_swap_landscape = SwitchIsSet(swapLandscapeToggle) ? 1 : 0;
   if (i != gv_swap_landscape) redisplay=True;

   b = SwitchIsSet(autoResizeToggle);
   if (b != app_res.auto_resize) {
     cb_autoResize(NULL,NULL,NULL);
   }

   b = app_res.respect_dsc;
   app_res.respect_dsc = SwitchIsSet(respectDSCToggle) ? True : False;
   if (b != app_res.respect_dsc) {
     cb_handleDSC(NULL,NULL,NULL);
     reopen=True;
   }

   value = widgets_getText(print_command);
   str = GV_XtNewString(value);
   if   (s_print_command == True) {INFMESSAGE(freeing) GV_XtFree(gv_print_command);} 
   else  s_print_command =  True;
   gv_print_command =  str;

   value = widgets_getText(scratch_dir);
   str = GV_XtNewString(value);
   if   (s_scratch_dir == True) {INFMESSAGE(freeing) GV_XtFree(app_res.scratch_dir);} 
   else  s_scratch_dir =  True;
   app_res.scratch_dir =  str;

   value = widgets_getText(default_save_dir);
   str = GV_XtNewString(value);
   if   (s_default_save_dir == True) {INFMESSAGE(freeing) GV_XtFree(app_res.default_save_dir);} 
   else  s_default_save_dir =  True;
   app_res.default_save_dir =  str;

   value = widgets_getText(filters);
   str = GV_XtNewString(value);
   GV_XtFree(gv_filters);
   gv_filters =  str;

   value = widgets_getText(dirs);
   str = GV_XtNewString(value);
   GV_XtFree(gv_dirs);
   gv_dirs =  str;

   value = widgets_getText(filter);
   str = GV_XtNewString(value);
   GV_XtFree(gv_filter);
   gv_filter =  str;

   if (s_media) GV_XtFree(app_res.default_pagemedia);
							n=0;
   XtSetArg(args[n], XtNlabel, &app_res.default_pagemedia);n++;
   XtGetValues(mediaButton, args, n);
   app_res.default_pagemedia = GV_XtNewString(app_res.default_pagemedia);
   i = doc_convStringToPageMedia(NULL,app_res.default_pagemedia);
   if (i != opt_pagemedia) {
     INFMESSAGE(pagemedia changed)
     opt_pagemedia = i;
     j = gv_pagemedia_auto;
     k = gv_pagemedia;
     gv_pagemedia_auto = 0;
     i = doc_convStringToPageMedia(doc,app_res.default_pagemedia);
     cb_setPagemedia(NULL,(XtPointer)i,(XtPointer)1);
     if ((j != gv_pagemedia_auto) || (k != gv_pagemedia)) redisplay = True;
   }
   s_media = True;

   if (s_fmedia) GV_XtFree(app_res.fallback_pagemedia);
							n=0;
   XtSetArg(args[n], XtNlabel, &app_res.fallback_pagemedia);n++;
   XtGetValues(fmediaButton, args, n);
   app_res.fallback_pagemedia = GV_XtNewString(app_res.fallback_pagemedia);
   gv_fallback_pagemedia = doc_convStringToPageMedia(NULL,app_res.fallback_pagemedia);
   s_fmedia = True;

   if (s_orient) GV_XtFree(app_res.default_orientation);
							n=0;
   XtSetArg(args[n], XtNlabel, &app_res.default_orientation);n++;
   XtGetValues(orientButton, args, n);
   app_res.default_orientation = GV_XtNewString(app_res.default_orientation);
   i = doc_convStringToDocOrient(app_res.default_orientation);
   if (i != opt_orientation) {
     INFMESSAGE(orientation changed)
     opt_orientation = i;
     j = gv_orientation_auto;
     k = gv_orientation;
     gv_orientation_auto = 0;
     cb_setOrientation(NULL,(XtPointer)i,(XtPointer)1);
     if ((j != gv_orientation_auto) || (k != gv_orientation)) redisplay = True;
   }
   s_orient = True;

   if (s_forient) GV_XtFree(app_res.fallback_orientation);
							n=0;
   XtSetArg(args[n], XtNlabel, &app_res.fallback_orientation);n++;
   XtGetValues(forientButton, args, n);
   app_res.fallback_orientation = GV_XtNewString(app_res.fallback_orientation);
   gv_fallback_orientation = doc_convStringToDocOrient(app_res.fallback_orientation);
   s_forient = True;

							n=0;
   XtSetArg(args[n], XtNlabel, &l);                     n++;
   XtGetValues(magButton, args, n);
   app_res.magstep = i = atoi(l);
   if (i != gv_magstep) {
     INFMESSAGE(magstep changed)
     redisplay = True;
   }
   gv_magstep = i;

							n=0;
   XtSetArg(args[n], XtNtmpDir, app_res.scratch_dir);	n++;
   XtSetArg(args[n], XtNfilters, gv_filters);		n++;
   XtSetArg(args[n], XtNdirs, gv_dirs);			n++;
   XtSetArg(args[n], XtNfilter, gv_filter);		n++;
   XtSetArg(args[n], XtNreverseScrolling,app_res.reverse_scrolling);n++;
   XtSetValues(FileSel, args, n);

   if (reopen) {
     if (gv_filename) {
        cb_stopInterpreter(page,NULL,NULL);
        show_page(REQUEST_REOPEN,NULL);
     }
   } else if (redisplay) show_page(REQUEST_OPTION_CHANGE,NULL);

   ENDMESSAGE(changeOptionsAtExit)
}

/*###############################################################################
   cb_popupOptionPopup
###############################################################################*/

void cb_popupOptionPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(popupOptionPopup)
   if (!optionPopupCreated) makeOptionPopup();
   if (!optionPopupVisible) {
      setOptionsAtEntry();
      popup_positionPopup(optionpopup,fileButton,POPUP_POSITION_POS,83,10);
      XtPopup(optionpopup, XtGrabNone);
      optionPopupVisible=True;
   }
   ENDMESSAGE(popupOptionPopup)
}      

/*###############################################################################
   cb_saveOptionPopup
   Note: the resources MUST be terminated by ':'
###############################################################################*/

static void new_arg(argiP,argvP,format,name,value)
  String *argiP;
  String *argvP;
  String format;
  String name;
  String value;
{
  *argiP = XtMalloc((strlen(format)+strlen(name)+1)*sizeof(char));
  strcpy(*argiP,name);
  strcat(*argiP,format);
  *argvP = XtMalloc((strlen(value)+1)*sizeof(char));
  strcpy(*argvP,value);
}

static
void cb_saveOptionPopup(w, client_data, call_data)
  Widget	w;
  XtPointer	client_data, call_data;
{
  int 	   argn = 0;
  String* argi[25];
  String* argv[25];
  char tmp[20];
  String l;
  Arg args[1];
  Cardinal n;

  BEGINMESSAGE(cb_saveOptionPopup)

  if (!optionPopupVisible) {
    INFMESSAGE(option popup not up)
    ENDMESSAGE(cb_saveOptionPopup)
    return;
  }
  new_arg(&(argi[argn]),&(argv[argn]),".printCommand:"        ,gv_intern_name,widgets_getText(print_command));
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),".scratchDir:"          ,gv_class       ,widgets_getText(scratch_dir));
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),".defaultSaveDir:"      ,gv_class       ,widgets_getText(default_save_dir));
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),".confirmPrint:"        ,gv_class       ,SwitchIsSet(confirmPrintToggle) ? "True" : "False");
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),".reverseScrolling:"    ,gv_class       ,SwitchIsSet(reverseScrollingToggle) ? "True" : "False");
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),".respectDSC:"          ,gv_class       ,SwitchIsSet(respectDSCToggle) ? "True" : "False");
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),".autoCenter:"          ,gv_class       ,SwitchIsSet(autoCenterToggle) ? "True" : "False");
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),".antialias:"           ,gv_class       ,SwitchIsSet(antialiasToggle) ? "True" : "False");
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),".autoResize:"          ,gv_class       ,SwitchIsSet(autoResizeToggle) ? "True" : "False");
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),".swapLandscape:"       ,gv_class       ,SwitchIsSet(swapLandscapeToggle) ? "True" : "False");
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),"*filters:"             ,gv_class       ,widgets_getText(filters));
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),"*filter:"              ,gv_class       ,widgets_getText(filter));
       ++argn;
  new_arg(&(argi[argn]),&(argv[argn]),"*dirs:"                ,gv_class       ,widgets_getText(dirs));
       ++argn;
                                    n=0;
  XtSetArg(args[n], XtNlabel, &l);  n++;
  XtGetValues(mediaButton, args, n);
  new_arg(&(argi[argn]),&(argv[argn]),".pageMedia:"           ,gv_class       ,l);
       ++argn;
  XtGetValues(fmediaButton, args, n);
  new_arg(&(argi[argn]),&(argv[argn]),".fallbackPageMedia:"   ,gv_class       ,l);
       ++argn;
  XtGetValues(orientButton, args, n);
  new_arg(&(argi[argn]),&(argv[argn]),".orientation:"         ,gv_class       ,l);
       ++argn;
  XtGetValues(forientButton, args, n);
  new_arg(&(argi[argn]),&(argv[argn]),".fallbackOrientation:",gv_class        ,l);
       ++argn;
  XtGetValues(magButton, args, n);
  sprintf(tmp,"%d",atoi(l));
  new_arg(&(argi[argn]),&(argv[argn]),".magstep:"            ,gv_class        ,tmp);
       ++argn;

   SaveOptionsToFile(argn,argi,argv);
   while (--argn >=0) {
     GV_XtFree(argi[argn]); 
     GV_XtFree(argv[argn]);
   }

   ENDMESSAGE(cb_saveOptionPopup)
}

/*###############################################################################
   cb_popdownOptionPopup
###############################################################################*/

void cb_popdownOptionPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(cb_popdownOptionPopup)
   if (optionPopupVisible) {
      cb_popdownNotePopup((Widget)NULL,(XtPointer)NULL,NULL);
      XtPopdown(optionpopup);
      optionPopupVisible=False;
   }
   ENDMESSAGE(cb_popdownOptionPopup)
}

/*###############################################################################
   cb_doneOptionPopup
###############################################################################*/

void cb_doneOptionPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(doneOptionPopup)
   if (optionPopupVisible) {
      changeOptionsAtExit();
   }
   ENDMESSAGE(doneOptionPopup)
}

/*###############################################################################
   makeOptionPopup
###############################################################################*/

void cb_changeMenuLabel(w, client_data, call_data)
  Widget	w;
  XtPointer	client_data, call_data;
{
  Arg      args[1];
  Cardinal n;
  char *l;
  Widget p;

  BEGINMESSAGE(cb_changeMenuLabel)
  p = XtParent(XtParent(w));
				      	n=0;
   XtSetArg(args[n], XtNlabel, &l);	n++;
   XtGetValues(w, args, n);
				      	n=0;
   XtSetArg(args[n], XtNlabel, l);	n++;
   XtSetValues(p, args, n);
  ENDMESSAGE(cb_changeMenuLabel)
}


static char *addTextTrans =
"\
<MapNotify>:display-caret(on,always)display-caret(off,always)\n\
<EnterNotify>:display-caret(on,always)\n\
<LeaveNotify>:display-caret(off,always)\
";

void makeOptionPopup()
{
   Arg          args[10];
   Cardinal     n;
   Dimension	minw,minh;
   Widget       w;
   char tmp[20];
   int i;
   static XtTranslations trans=(XtTranslations)NULL;

   BEGINMESSAGE(makeOptionPopup)

   if (optionPopupCreated) {INFMESSAGE(popup exists) ENDMESSAGE(makeOptionPopup) }

        						n=0;
        XtSetArg(args[n], XtNallowShellResize, True);	n++;
   OPTIONS_POPUP = XtCreatePopupShell(OPTIONS_POPUP_NAME,transientShellWidgetClass,OPTIONS_TOPLEVEL, args, n);

         						n=0;
        XtSetArg(args[n], XtNresizeWidth, True);	n++;
        XtSetArg(args[n], XtNresizeHeight, True);	n++;
        XtSetArg(args[n], XtNconditionedResize, False);	n++;
        XtSetArg(args[n], XtNmaximumWidth, 0);	 	n++;
        XtSetArg(args[n], XtNmaximumHeight,0);	 	n++;
   optionControl = XtCreateManagedWidget("optionControl",aaaWidgetClass,OPTIONS_POPUP,args,n);

   miscLabel              = XtCreateManagedWidget("misc",labelWidgetClass,optionControl,NULL,(Cardinal)0);
   antialiasToggle        = XtCreateManagedWidget("antialias",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   confirmPrintToggle     = XtCreateManagedWidget("confirmPrint",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   reverseScrollingToggle = XtCreateManagedWidget("scrolling",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   autoCenterToggle       = XtCreateManagedWidget("autoCenter",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   autoResizeToggle       = XtCreateManagedWidget("autoResize",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   swapLandscapeToggle    = XtCreateManagedWidget("swapLandscape",switchWidgetClass,optionControl,NULL,(Cardinal)0);
   respectDSCToggle       = XtCreateManagedWidget("respectDSC",switchWidgetClass,optionControl,NULL,(Cardinal)0);

                                          n=0;
   XtSetArg(args[n], XtNresize, False);  ++n;
   mediaLabel  = XtCreateManagedWidget("mediaLabel",labelWidgetClass,optionControl,args,n);
   mediaButton = XtCreateManagedWidget("mediaButton",mbuttonWidgetClass,optionControl,args,n);
   mediaMenu   = XtCreatePopupShell("menu", simpleMenuWidgetClass,mediaButton, args,n);
   w           = XtCreateManagedWidget("Automatic",smeBSBObjectClass,mediaMenu,args,n);
		 XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
   fmediaLabel  = XtCreateManagedWidget("fmediaLabel",labelWidgetClass,optionControl,args,n);
   fmediaButton = XtCreateManagedWidget("fmediaButton",mbuttonWidgetClass,optionControl,args,n);
   fmediaMenu   = XtCreatePopupShell("menu", simpleMenuWidgetClass,fmediaButton,args,n);
		 for (i = 0; papersizes[i].name; i++) {
		   if (i > 0) {
		     if ((papersizes[i].width == papersizes[i-1].width) &&
			 (papersizes[i].height == papersizes[i-1].height)) {
		       continue;
		     }
		   }
		   w = XtCreateManagedWidget(papersizes[i].name,smeBSBObjectClass, mediaMenu,NULL,(Cardinal)0);
  		       XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		   w = XtCreateManagedWidget(papersizes[i].name,smeBSBObjectClass, fmediaMenu,NULL,(Cardinal)0);
		       XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		 }

   orientLabel   = XtCreateManagedWidget("orientLabel",labelWidgetClass,optionControl,args,n);
   orientButton  = XtCreateManagedWidget("orientButton",mbuttonWidgetClass,optionControl,args,n);
   orientMenu    = XtCreatePopupShell("menu", simpleMenuWidgetClass,orientButton, args,n);
                   w = XtCreateManagedWidget("Automatic",smeBSBObjectClass,orientMenu,args,n);
		       XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
   forientLabel  = XtCreateManagedWidget("forientLabel",labelWidgetClass,optionControl,args,n);
   forientButton = XtCreateManagedWidget("forientButton",mbuttonWidgetClass,optionControl,args,n);
   forientMenu   = XtCreatePopupShell("menu", simpleMenuWidgetClass,forientButton, args,n);
		   for (i = 0; orientations[i]; i++) {
		     w = XtCreateManagedWidget(orientations[i],smeBSBObjectClass, orientMenu,NULL,(Cardinal)0);
		         XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		     w = XtCreateManagedWidget(orientations[i],smeBSBObjectClass, forientMenu,NULL,(Cardinal)0);
		         XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		   }

   magLabel   = XtCreateManagedWidget("magLabel",labelWidgetClass,optionControl,args,n);
   magButton  = XtCreateManagedWidget("magButton",mbuttonWidgetClass,optionControl,args,n);
   magMenu    = XtCreatePopupShell("menu", simpleMenuWidgetClass,magButton, args,n);
		for (i = app_res.minimum_magstep; i<= app_res.maximum_magstep; i++) {
		  sprintf(tmp,"  %d  ",i);
		  w = XtCreateManagedWidget(tmp,smeBSBObjectClass, magMenu,NULL,(Cardinal)0);
		      XtAddCallback(w, XtNcallback,cb_changeMenuLabel,NULL); 
		}

    if (app_res.magstep < app_res.minimum_magstep) app_res.magstep = app_res.minimum_magstep;
    if (app_res.magstep > app_res.maximum_magstep) app_res.magstep = app_res.maximum_magstep;
    gv_magstep = app_res.magstep;

        						n=0;
   w = XtCreateManagedWidget("done", buttonWidgetClass,optionControl, args, n);
         XtAddCallback(w, XtNcallback, cb_doneOptionPopup,NULL); 
   w = XtCreateManagedWidget("save", buttonWidgetClass,optionControl, args, n);
         XtAddCallback(w, XtNcallback, cb_saveOptionPopup,NULL);
   w = XtCreateManagedWidget("dismiss", buttonWidgetClass,optionControl, args, n);
         XtAddCallback(w, XtNcallback, cb_popdownOptionPopup, NULL);
 
   print_command    = widgets_createLabeledLineTextField("printCommand", optionControl);
   scratch_dir      = widgets_createLabeledLineTextField("scratchDir",   optionControl);
   default_save_dir = widgets_createLabeledLineTextField("saveDir",      optionControl);
   filter           = widgets_createLabeledLineTextField("filter",       optionControl);
   if (!trans) trans=XtParseTranslationTable(addTextTrans);
   XtOverrideTranslations(print_command,trans);
   XtOverrideTranslations(scratch_dir,trans);
   XtOverrideTranslations(default_save_dir,trans);
   XtOverrideTranslations(filter,trans);

   filters    = widgets_createLabeledTextField("filters", optionControl);
   XtOverrideTranslations(filters,trans);

   dirs      = widgets_createLabeledTextField("dirs", optionControl);
   XtOverrideTranslations(dirs,trans);
/*
                                               n=0;
   XtSetArg(args[n], XtNtranslations, trans);  ++n;
   XtSetValues(print_command, args, n);
   XtSetValues(scratch_dir, args, n);
   XtSetValues(default_save_dir, args, n);
*/

   setOptionsAtEntry();
   XtRealizeWidget(OPTIONS_POPUP);

   AaaWidgetGetNaturalSize((AaaWidget)optionControl,&minw,&minh);
   IIMESSAGE(minw,minh)
                                          n=0;
   XtSetArg(args[n], XtNminWidth, minw);  ++n;
   XtSetArg(args[n], XtNminHeight, minh); ++n;
   XtSetArg(args[n], XtNmaxWidth, XtUnspecifiedShellInt);  ++n;
/*
   XtSetArg(args[n], XtNmaxHeight, minh); ++n;
*/
   XtSetValues(OPTIONS_POPUP, args, n);

/*
                                       n=0;
   XtSetArg(args[n], XtNwidth, minw+130);  ++n;
   XtSetValues(optionControl, args, n);
*/
   XSetWMProtocols(XtDisplay(OPTIONS_POPUP),XtWindow(OPTIONS_POPUP),&wm_delete_window,1);

   optionPopupCreated = True;  
                                
   ENDMESSAGE(makeOptionPopup)
}
