// SapHandler.java
// $Id: SapHandler.java,v 1.2 1998/01/22 14:40:30 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.www.sap;

public interface SapHandler {

    /**
     * This is the first announcement for the following session.
     * The handler can do anything with the announced session.
     * @param s The session that was newly announced.
     * @return A boolean, if <strong>true</strong> session description is kept
     * internally by the SAP manager, otherwise the session is just dropped.
     */

    public boolean handleSapAnnounce(SapSession s);

    /**
     * The given session has been deleted.
     * @param s The SapSession whose deletion has been annnounced.
     */

    public void handleSapDeletion(SapSession s);

}
