// MapFrame.java
// $Id: MapFrame.java,v 1.1 1998/02/19 10:55:11 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.map ;

import java.net.* ;
import java.util.*;

import org.w3c.jigsaw.frames.*;
import org.w3c.tools.resources.*;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.jigsaw.http.*;
import org.w3c.jigsaw.html.*;
import org.w3c.www.http.HTTP ;


public class MapFrame extends HTTPFrame {

  protected MapResource mapresource = null;

  public void registerResource(FramedResource resource) {
    super.registerResource(resource);
    if (resource instanceof MapResource)
      mapresource = (MapResource) resource;
  }

  /** 
   * This method will try to get the two coordinates of the imagemap
   * from the request query string, and will the appropriate
   * redirection reply.
   *
   * @param request the HTTP request
   * @return the HTTP reply
   */
  // MapResource extends FileResource
  public Reply getFileResource(Request request)
    throws ProtocolException, NotAProtocolException
  {
    if (mapresource == null) 
      throw new NotAProtocolException("this frame is not attached to a "+
				      "MapResource. ("+
				      resource.getIdentifier()+")");
    try {
      mapresource.checkContent();
      String url = null ;

      Map map = mapresource.getMap();
	    
      url = map.getMatchingURL(parseSelection(request.getQueryString()));
      if(url == null) {
	// FIXME: Status code ?
	Reply error = createDefaultReply(request,HTTP.OK) ;
	error.setStream
	  (generateError
	   ("Malformed query: " +
	    "two numerical coordinates are needed.")) ;
	throw new HTTPException(error) ;
      } else {
	Reply reply =
	  createDefaultReply(request,HTTP.MOVED_TEMPORARILY) ;
		
	reply.setLocation(new URL(getURL(request), url));
		
	HtmlGenerator g = new HtmlGenerator("Document moved") ;
	g.append("<h1>Document Moved</h1>"+
		 "<p>This document has moved "+
		 "<a href=\"" + url +"\">here</a>.<p>") ;
	reply.setStream(g) ;
	return reply ;
      }

    } catch(MapException ex) {
      Reply error =
	createDefaultReply(request,HTTP.INTERNAL_SERVER_ERROR) ;
      error.setStream(generateError
		      ("Bad map specification: "+ex.getMessage())) ;
      throw new HTTPException(error) ;
    } catch(Exception ex) {
      Reply error =
	createDefaultReply(request,HTTP.INTERNAL_SERVER_ERROR) ;
      error.setStream(generateError
		      ("Problems reading map definition file")) ;
      throw new HTTPException(error) ;
    }
  }

  private HtmlGenerator generateError(String msg)
  {
    HtmlGenerator g = new HtmlGenerator("Image Map Error") ;
    g.append("<h1>Image Map Error</h1>") ;
    if(msg != null)
      g.append("<p>"+msg+"</p>") ;
    return g ;
  }

  private Point parseSelection(String line)
  {
    if(line == null) return null;

    StringTokenizer strtok = new StringTokenizer(line,",");
    Point selection = null;

    try {
      selection = new Point();
      selection.x = Integer.parseInt(strtok.nextToken().trim());
      selection.y = Integer.parseInt(strtok.nextToken().trim());
      if(strtok.hasMoreTokens()) selection = null;
    } catch(NumberFormatException ex) {
      selection = null;
    } catch(NoSuchElementException ex) {
      selection = null;
    } finally {
      return selection;
    }
  }

}
