// DateAttributeEditor.java
// $Id: DateAttributeEditor.java,v 1.10 1998/02/11 10:20:17 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigadm.editors ;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import org.w3c.tools.resources.*;
import org.w3c.tools.widgets.*;
import org.w3c.jigsaw.admin.*;
import org.w3c.jigadm.*;

public class DateAttributeEditor extends AttributeEditor {
    
    /** 
     * an inner ActionListener for the '+' and '-' Buttons
     */

    class DateActionListener implements ActionListener {
	int field = 0;
	
        public void actionPerformed(ActionEvent ae) {
	    if(ae.getActionCommand().equals("+"))
		updateValue(field, true);
	    else
		updateValue(field, false);
	}

      DateActionListener(int f) {
	    field = f;
	}
    }

    private Calendar c;
    private Date origd;
    Date currd;
    Panel widget;
    private Label d, m, y;
    private static final String smonth[] = {"Jan", "Feb", "Mar", "Apr",
					    "May", "Jun", "Jul", "Aug",
					    "Sep", "Oct", "Nov", "Dec" };
    
    /**
     * reset the strings in the Textfields according to the new date
     */
   
    private void updateFields() {
	d.setText((new Integer(c.get(Calendar.DAY_OF_MONTH))).toString());
	m.setText(smonth[c.get(Calendar.MONTH)]);
	y.setText((new Integer(c.get(Calendar.YEAR))).toString());
    }

    /**
     * update the new date value, according to the field defined in
     * the Calendar
     * @see Calendar
     * @param field the field of the Calendar to be modified
     * @param plus a boolean which determine the change sign
     */

    protected void updateValue(int field, boolean plus) {
	c.setTime(currd);
	c.roll(field, plus);
	currd = c.getTime();
	// jdk 1.1 kludge
	c.setTime(currd);
	updateFields();
    }

    /**
     * Tells if the edited value has changed
     * @return true if the value changed.
     */
 
    public boolean hasChanged() {
	return (!origd.equals(currd));
    }

    /**
     * set the current value to be the original value, ie: changed
     * must return <strong>false</strong> after a reset.
     */

    public void clearChanged() {
	origd = currd;
    }

    /**
     * reset the changes (if any)
     */
    
    public void resetChanges() {
	currd = origd;
	c.setTime(currd);
	updateFields();
    }

    /**
     * Get the current value of the edited value
     * @return an object or <strong>null</strong> if the object was not
     * initialized
     */

    public Object getValue() {
	return new Long(currd.getTime());
    }

    /**
     * Add a Listener to this editor.
     * @param el a listener
     */

    public void setValue(Object o) {
	if(o instanceof Date) {
	    currd = (Date)o;
	    c.setTime(currd);
	    updateFields();
	}
    }

    /**
     * get the Component created by the editor.
     * @return a Component
     */
 
    public Component getComponent() {
	return widget;
    }

   public DateAttributeEditor() {
       ImageButton pl, mi;
       Panel wd, wm, wy;
       DateActionListener dae;
       PropertyManager pm = PropertyManager.getPropertyManager();

       Image up = Toolkit.getDefaultToolkit().getImage(
	   pm.getIconLocation("shadowleft"));
       Image down = Toolkit.getDefaultToolkit().getImage(
	   pm.getIconLocation("shadowright"));

       widget = new Panel(new BorderLayout());
       wd = new Panel(new BorderLayout());
       wm = new Panel(new BorderLayout());
       wy = new Panel(new BorderLayout());
       // add the "day" panel
       d = new Label();
       dae = new DateActionListener(Calendar.DAY_OF_MONTH);
       wd.add("Center", d);
       pl = new ImageButton(up);
       pl.addActionListener(dae);
       pl.setActionCommand("-");
       wd.add("West", pl);
       mi = new ImageButton(down);
       mi.addActionListener(dae);
       mi.setActionCommand("+");
       wd.add("East", mi);
       // then the "Month" panel
       m = new Label();
       dae = new DateActionListener(Calendar.MONTH);
       wm.add("Center", m);
       pl = new ImageButton(up);
       pl.addActionListener(dae);
       pl.setActionCommand("-");
       wm.add("West", pl);
       mi = new ImageButton(down);
       mi.addActionListener(dae);
       mi.setActionCommand("+");
       wm.add("East", mi);
       // then the "Year" panel
       y = new Label();
       dae = new DateActionListener(Calendar.YEAR);
       wy.add("Center", y);
       pl = new ImageButton(up);
       pl.addActionListener(dae);
       pl.setActionCommand("-");
       wy.add("West", pl);
       mi = new ImageButton(down);
       mi.addActionListener(dae);
       mi.setActionCommand("+");
       wy.add("East", mi);   
   
       widget.add("West", wd);
       widget.add("Center", wm);
       widget.add("East", wy);
       c = Calendar.getInstance();
   }

    /**
     * Initialize the filter
     * @param w the ResourceWrapper father of the attribute
     * @param a the Attribute we are editing
     * @param o the value of the above attribute
     * @param p some Properties, used to fine-tune the editor
     */
 
   public void initialize(RemoteResourceWrapper w, Attribute a,  Object o,
			  Properties p)
       throws RemoteAccessException
    {
	RemoteResource r = w.getResource();
	if(o == null) {
	    Date d = null;
	    try {
		d = new Date(((Long)r.getValue(a.getName())).longValue());
		
		if(d == null)
		    if(a.getDefault() != null)
			d = new Date(((Long) a.getDefault()).longValue());
	    } catch (Exception ex) {
		// a fancy error?
	    }
	    if ( d != null ) {
		origd = d;
		c.setTime(d);
		updateFields();
	    } else {
	 	origd = new Date();
	    }
	    currd = origd;
	} else {
	    if(o instanceof Long) {
		origd = new Date(((Long)o).longValue());
		c.setTime(origd);
	    }
	}
	updateFields();
	currd = origd;
    }
}
    
