/*
 *  StringToURL.java
 *
 *  Copyright 1997 Massachusetts Institute of Technology.
 *  All Rights Reserved.
 *
 *  Author: Ora Lassila
 *
 *  $Id: StringToURL.java,v 1.2 1998/01/22 14:33:53 bmahe Exp $
 */

package org.w3c.www.pics;

import java.net.URL;
import java.net.MalformedURLException;

public class StringToURL implements Mapper {

  public Object map(Object value) throws PICSParserException
  {
    try {
      return new URL((String)value);
    }
    catch (MalformedURLException e) {
      throw new PICSParserException("Unable to parse a URL", e);
    }
  }

}
