// AttributeChangedEvent.java
// $Id: AttributeChangedEvent.java,v 1.4 1998/01/22 12:59:24 bmahe Exp $  
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.resources.event;

import org.w3c.tools.resources.*;

public class AttributeChangedEvent extends ResourceEvent {

  /**
   * The index of the attribut modified.
   */
  protected Attribute attr;

  /**
   * The attribut new value.
   */
  protected Object newvalue = null;

  
  public Attribute getAttribute() {
    return attr;
  }

  public Object getNewValue() {
    return newvalue;
  }
  /**
   * Create an attribute change event.
   * @param source The resource whose attribute has changed.
   * @param idx The index of the attribute that has changed.
   * @param newvalue The new attribuyte value.
   */

  public String toString() {
    ResourceReference rr = (ResourceReference) getSource();
    String ssource = null;
    try {
      Resource resource = rr.lock();
      ssource = resource.getURLPath();
    } catch (InvalidResourceException ex) {
      ssource = "invalid";
    } finally {
      rr.unlock();
    }
    return ("AttributeChangedEvent : ["+ssource+" : "+attr.getName()+
	    " <- "+newvalue+"]");
  }

  public AttributeChangedEvent(ResourceReference ref, 
			       Attribute attr, 
			       Object newvalue) 
  {
    super(ref, Events.ATTRIBUTE_EVENT);
    this.attr = attr;
    this.newvalue = newvalue;
  }


}
