// DirectoryResource.java
// $Id: LoopCommand.java,v 1.1 1998/01/22 14:15:27 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.ssi.commands;

import java.util.*;

import org.w3c.www.http.*;
import org.w3c.jigsaw.http.*;
import org.w3c.tools.resources.*;
import org.w3c.util.*;
import org.w3c.jigsaw.ssi.*;

/**
 * Implementation of the SSI <code>loop</code> command.  
 * @author Benoit Mahe <bmahe@sophia.inria.fr>
 */
public class LoopCommand implements ControlCommand {
  private final static String  NAME  = "loop";
  private final static boolean debug = true;
    
  private static final String keys[] = { "name" };

  protected static Hashtable loops = null;

  static {
    loops = new Hashtable(23);
  }

  protected static int getPosition(String name)
    throws ControlCommandException
  {
    Integer pos = (Integer)loops.get(name);
    if (pos == null)
      throw new ControlCommandException(NAME,"Position unknown.");
    else return pos.intValue();
  }

  public void setPosition(SSIFrame ssiframe,
			  CommandRegistry registry,
			  ArrayDictionary parameters,
			  Dictionary variables,
			  int position) 
  {
    Object values[] = parameters.getMany(keys);
    String name     = (String) values[0];
    if (name != null)
      loops.put(ssiframe.getResource().getURLPath()+
		":"+name, new Integer(position));
  }
  
  public String getValue(Dictionary variables, String var) {
    return null;
  }

  public Reply execute(SSIFrame ssiframe
		       , Request request
		       , ArrayDictionary parameters
		       , Dictionary variables) 
  {
    return ssiframe.createCommandReply(request, HTTP.OK);
  }

  public int jumpTo(SSIFrame ssiframe,
		    CommandRegistry registry,
		    ArrayDictionary parameters,
		    Dictionary variables)
    throws ControlCommandException
  {
    Object values[] = parameters.getMany(keys);
    String name     = (String) values[0];
    if (name != null)
      return (getPosition(ssiframe.getResource().getURLPath()+":"+name)+1);
    else 
      throw new ControlCommandException(NAME,"Position unknown.");
  }
  
  public String getName() {
    return NAME;
  }

}
