// CvsDirectoryHandler.java
// $Id: CvsDirectoryHandler.java,v 1.16 1997/07/28 08:32:48 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

//
// FIXME add extra environment parameter to all public methods
// witch run cvs.
//

package w3c.jigsaw.cvs ;

import w3c.cvs.* ;
import w3c.www.http.*;
import w3c.jigsaw.http.* ;
import w3c.jigsaw.auth.AuthFilter;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.html.HtmlGenerator ;

public class CvsDirectoryHandler implements CvsHandlerInterface {
    CvsDirectory cvs = null ;

    /**
     * Perform the action on the given entity.
     * @param request The request that triggered this method call.
     * @param action The action to perform.
     * @param names Name of files to apply the action to.
     * @exception HTTPException If running the action failed.
     */

    public void perform (Request request
			 , String action
			 , String names[])
	throws HTTPException
    {
	try {
	    if ( action.equals ("add") ) {
	        String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		cvs.add (names, env) ;
	    } else if ( action.equals ("remove") ) {
		cvs.remove(names) ;
	    } else if ( action.equals ("update") ) {
		cvs.update(names) ;
	    } else if ( action.equals("commit") ) {
		String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		cvs.commit(names
			   , ((u != null)
			      ? "("+u+") changed through Jigsaw, no comments"
			      : "changed through Jigsaw, no comments"),
			   env);
	    } else {
		Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
		HtmlGenerator g = new HtmlGenerator ("Bad CVS command") ;
		g.append ("<p>Your command "
			  + "<strong>"+ action + "</strong>"
			  + " wasn't undesrtood."
			  + "<hr>" + this.getClass().getName()) ;
		error.setStream (g) ;
		throw new HTTPException (error) ;
	    }
	 } catch (CvsException ex) {
	    String msg = action+" in "+cvs.getDirectory()+" failed";
	    throw new HTTPException(CvsDirectoryResource.error(request
							       , msg
							       , ex));
	}
    }

    /**
     * Perform the action on the given entity.
     * @param action The action to perform.
     * @param names The names on which the action should be performed.
     * @param comment A string of comments describing the change.
     * @exception HTTPException If running the action failed.
     */

    public void perform (Request request
			 , String action
			 , String names[]
			 , String comment) 
	throws HTTPException
    {
for(int i = 0 ; i < names.length ; i++)
System.out.println("*** perform "+action+" on "+names[i]);
	try {
	    if ( action.equals ("add") ) {
	        String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		cvs.add(names, env) ;
	    } else if ( action.equals ("removelf") ) {
		cvs.remove(names) ;
	    } else if ( action.equals("update") ) {
		cvs.update(names) ;
	    } else if ( action.equals ("commit") ) {
		String u = (String)request.getState(AuthFilter.STATE_AUTHUSER);
		String env[] = {"USER="+u , "LOGNAME="+u };
		cvs.commit(names, 
			   ((u!=null) ? "("+u+") "+comment : comment),
			   env);
	    } else {
		Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
		HtmlGenerator g = new HtmlGenerator ("Bad CVS command") ;
		g.append ("<p>Your command "
			  + "<strong>"+ action + "</strong>"
			  + " wasn't undesrtood."
			  + "<hr>" + this.getClass().getName()) ;
		error.setStream (g) ;
		throw new HTTPException (error) ;
	    }
	} catch (CvsException ex) {
	    String msg = action+" in "+cvs.getDirectory()+" failed";
	    throw new HTTPException(CvsDirectoryResource.error(request
							       , msg
	    						       , ex));
	}
    }

    CvsDirectoryHandler(CvsDirectory cvs) {
	super() ;
	this.cvs = cvs ;
    }
}
