// SessionOutputStream.java
// $Id: SessionOutputStream.java,v 1.1 1996/04/10 13:53:04 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mux ;

import java.io.* ;

public class SessionOutputStream extends OutputStream implements MUX {
    byte     single[] = null ;
    Session  session  = null ;
    MPWriter writer   = null ;
    boolean  closed   = false ;

    /**
     * Flush any pending data.
     */

    public void flush() 
	throws IOException
    {
	writer.flush() ;
    }
	
    /**
     * Close this session output stream.
     */

    public synchronized void close () 
	throws IOException 
    {
	if ( closed )
	    return ;
	closed = true ;
	int protid = session.getProtocolIdentifier() ;
	if ( protid != -1 )
	    writer.writeMessage (session.getIdentifier()
				 , (byte) (MUX_FIN|MUX_LONG_LENGTH)
				 , protid
				 , null, 0, 0) ;
	else
	    writer.writeMessage (session.getIdentifier()
				 , (byte) MUX_FIN
				 , -1
				 , null, 0, 0) ;
	writer.flush() ;
    }

    /**
     * Write one byte of output.
     * @param b The byte to write.
     * @exception IOException If some IO error occured.
     */

    public synchronized void write (int b) 
	throws IOException
    {
	if ( closed )
	    throw new IOException ("write on a closed session.") ;
	single[0] = (byte) (b &0xff) ;
	write (single, 0, 1) ;
    }

    /**
     * Write an array of bytes.
     * @param buf The data to write.
     * @param off Offset in above buffer.
     * @param len Length of data to write.
     * @exception IOException If some IO error occured.
     */

    public synchronized void write (byte b[], int off, int len)
	throws IOException
    {
	if ( closed )
	    throw new IOException ("write on a closed session.") ;
	writer.writeData (session.getIdentifier(), b, off, len) ;
    }

    SessionOutputStream (Session session, boolean closed) 
	throws IOException
    {
	this.session = session ;
	this.writer  = session.getWriter() ;
	this.single  = new byte[1] ;
	this.closed  = closed ;
    }
	
	
}
