// Session.java
// $Id: Session.java,v 1.1 1996/04/10 13:53:01 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mux ;

import java.io.* ;

public class Session {
    SessionInputStream  input  = null ;
    SessionOutputStream output = null ;
    MPStream            stream = null ;
    int                 id     = -1 ;
    int                 protid = -1 ;
    boolean             pending = false ;
    
    boolean input_closed  = false ;
    boolean output_closed = false ;

    /**
     * Is this session waiting for someone to accept it.
     */

    protected synchronized boolean isPending() {
	return pending ;
    }

    /**
     * Mark this session as accepted.
     */

    protected synchronized Session accept(int protid) {
	if ( pending ) {
	    if ((protid < 0) || (this.protid == protid)) {
		pending = false ;
		return this ;
	    }
	}
	return null ;
    }

    /**
     * Close this session input stream.
     */

    protected synchronized void closeInputStream() 
	throws IOException
    {
	if ( input_closed )
	    return ;
	if ( input != null )
	    input.close() ;
	input_closed = true ;
    }

    /**
     * Close this session output stream.
     */

    protected synchronized void closeOutputStream()
	throws IOException
    {
	if ( output_closed )
	    return ;
	if ( output != null )
	    output.close() ;
	output_closed = true ;
    }

    /**
     * Get the writer for this session.
     */

    protected MPWriter getWriter () {
	return stream.getWriter() ;
    }

    /**
     * Get the reader for this session.
     */

    protected MPReader getReader() {
	return stream.getReader() ;
    }

    /**
     * Get this session protocol identifier.
     * @return The protocol identifier, or <strong>-1</strong> if no protocol
     *    identifier was defined for this session.
     */

    public int getProtocolIdentifier() {
	return protid ;
    }

    /**
     * Get this session identifier.
     */

    public int getIdentifier () {
	return id ;
    }

    /**
     * Close this session.
     * Closes both the input and the output stream, and unregister the
     * session from the multiplexed stream. Once this method is done, the
     * session identifier is free for reuse.
     */

    public void close()
	throws IOException
    {
	closeInputStream() ;
	closeOutputStream() ;
	stream.unregisterSession(this) ;
    }

    /**
     * Get this session input stream.
     * @return An instance of InputStream.
     * @exception IOException In case of IO errors.
     */

    public synchronized SessionInputStream getInputStream() 
	throws IOException
    {
	if ( input == null )
	    input = new SessionInputStream(this, input_closed) ;
	return input ;
    }

    /**
     * Get this session output stream.
     * @return an instance of OutputStream.
     * @exception IOException In case of IO errors.
     */

    public synchronized SessionOutputStream getOutputStream()
	throws IOException
    {
	if ( output == null )
	    output = new SessionOutputStream(this, output_closed) ;
	return output ;
    }

    Session (MPStream stream, int id, int protid, boolean pending) {
	this.stream  = stream ;
	this.id      = id ;
	this.protid  = protid ;
	this.pending = pending ;
    }

    Session (MPStream stream, int id, boolean pending) {
	this (stream, id, -1, pending) ;
    }

    Session (MPStream stream, int id, int protid) {
	this (stream, id, protid, false) ;
    }

    Session (MPStream stream, int id) {
	this (stream, id, -1, false) ;
    }
}
