// EchoServer.java
// $Id: EchoServerLauncher.java,v 1.1 1996/04/10 13:52:51 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mux ;

import java.net.* ;
import java.io.* ;

class EchoServer extends Thread {
    InputStream  input   = null ;
    OutputStream output  = null ;
    boolean      verbose = true ;

    void trace (String msg) {
	if ( verbose ) 
	    System.out.println (getName()+": "+msg) ;
    }

    void loop () 
	throws IOException 
    {
	byte buffer[] = new byte[512] ;
	int  got      = 0 ;
	int  count    = 0 ;

	trace ("entering loop") ;
	while ((got = input.read(buffer, 0, buffer.length)) > 0) {
	    trace ("got "+got+" bytes: ["+new String(buffer, 0, 0, got)+"]") ;
	    output.write (buffer, 0, got) ;
	    if ( count++ > 50 ) {
		System.out.println(getName()+": "+count+".") ;
		count = 0 ;
	    }
	    output.flush() ;
//	    Thread.yield() ;
	}
	trace ("********* done ********** .") ;
    }

    public void run() {
	trace ("starting") ;
	try {
	    loop() ;
	} catch (Throwable ex) {
	    ex.printStackTrace() ;
	}
    }

    
    EchoServer (String name, InputStream input, OutputStream output) {
	this.input  = input ;
	this.output = output ;
	setName (name) ;
    }
}


public class EchoServerLauncher implements Runnable {
    ServerSocket socket = null ;

    void trace (String msg) {
	System.out.println ("server: " + msg) ;
    }

    public void run() {
	try {
	    while (true) {
		trace ("listeing for clients.") ;
		Socket   client = socket.accept() ;
		if ( client != null ) {
		    MPStream mpclient = new MPStream(true, client) ; 
		    trace ("got client !") ;
		    while ( true ) {
			trace ("waiting for new channel") ;
			Session ses  = mpclient.accept(80) ;
			EchoServer s = new EchoServer("["
						      + ses.getIdentifier()
						      + "]"
						      , ses.getInputStream()
						      , ses.getOutputStream());
			s.start() ;
		    }
		}
	    }
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	}
    }

    EchoServerLauncher (int port)
	throws IOException
    {
	this.socket = new ServerSocket (port) ;
    }

    public static void main (String args[]) 
	throws IOException
    {
	int port = Integer.parseInt(args[0]) ;
	EchoServerLauncher server = new EchoServerLauncher(port) ;
	new Thread(server).start() ;
    }

}
