// EchoClientLauncher.java
// $Id: EchoClientLauncher.java,v 1.1 1996/04/10 13:52:50 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mux ;

import java.io.* ;
import java.net.* ;

class EchoClient extends Thread {
    InputStream  input   = null ;
    OutputStream output  = null ;
    boolean      verbose = true ;
    int          count   = 100000 ;

    private void trace (String msg) {
	if ( verbose )
	    System.out.println (getName()+": " + msg) ;
    }

    public void run () {
	int  counter  = 0 ;
	byte buffer[] = new byte[512] ;
	
	try {
	    trace ("starting") ;
	    // Run for count messages:
	    while ( --count >= 0 ) {
		counter++ ;
		String m   = getName() + "(" + counter +")" ;
		byte   b[] = new byte[m.length()] ;
		m.getBytes(0, b.length, b, 0) ;
		trace ("writing "+b.length+" bytes ["+m+"]") ;
		output.write (b, 0, b.length) ;
		output.flush() ;
		int got = input.read(buffer, 0, buffer.length) ;
		trace ("got "+got+" ["+new String(buffer, 0, 0, got)+"]");
		if ( (counter & 0x1f) == 0 )
		    System.out.println (getName()+": "+counter+".");
	    }
	    // Close the output stream
	    output.close() ;
	    trace ("done.") ;
	} catch (IOException ex) {
	    ex.printStackTrace() ;
	}
    }

    EchoClient (String name, InputStream input, OutputStream output) {
	this.input  = input ;
	this.output = output ;
	setName (name) ;
    }

    EchoClient(String name, int count,InputStream input,OutputStream output) {
	this.input = input ;
	this.output = output ;
	setName(name) ;
	this.count = count ;
    }

}


public class EchoClientLauncher {
    
    public static void main (String args[]) 
	throws IOException , UnknownHostException
    {
	String host   = args[0] ;
	int    port   = Integer.parseInt (args[1]) ;
	Socket socket = new Socket (host, port) ;
	MPStream mp   = new MPStream(false, socket) ;

	for (int i = 2 ; i < args.length ; i += 2) {
	    Session ses = mp.connect(80) ;
	    EchoClient c = new EchoClient (args[i]
					   , Integer.parseInt(args[i+1])
					   , ses.getInputStream()
					   , ses.getOutputStream()) ;
	    c.start() ;
	}

    }    
}
