// MIMETypeFormatException.java
// $Id: MIMETypeFormatException.java,v 1.1 1996/04/10 13:52:22 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mime ;

/**
 * This exception signals an invalid MIME type.
 * MIMEType wasn't able to parse the given string into a MIMEType object.
 * @see w3c.mime.MIMEType
 */

public class MIMETypeFormatException extends Exception {
    public String spec = null ;

    public MIMETypeFormatException (String spec) {
	super ("Invalid MIME type specification: "+ spec) ;
	this.spec = spec ;
    }

}
