// MIMEMPInputStream.java
// $Id: MIMEMultipartInputStream.java,v 1.1 1996/04/10 13:52:16 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mime ;

import java.io.* ;

/**
 * A class to handle multipart MIME input streams. See RC 1521.
 * This class handles multipart input streams, as defined by the RFC 1521. 
 * It prvides a sequential interface to all MIME parts, and for each part
 * it delivers a suitable InputStream for getting its body.
 */

public class MIMEMultipartInputStream extends MIMEInputStream {
    byte boundary[] = null ;
    byte buffer[]   = null ;
    boolean partEnd = false ;
    boolean fileEnd = false ;
    
    // Skip to next input boundary, set stream at begining of content:
    // Returns true if boundary was found, false otherwise.

    protected boolean skipToBoundary() 
	throws IOException
    {
	int ch = in.read() ;
      skip:
	while ( ch != -1 ) {
	    if ( ch != '-' ) {
		ch = in.read() ;
		continue ;
	    }
	    if ((ch = in.read()) != '-') 
		continue ;
	    in.mark (boundary.length) ;
	    in.read (buffer) ;
	    for (int i = 0 ; i < boundary.length ; i++) {
		if ( buffer[i] != boundary[i] ) {
		    in.reset() ;
		    ch = in.read() ;
		    continue skip ;
		}
	    }
	    // FIXME: should we check for a properly syntaxed part, which
	    // means that we should expect '\r\n'. For now, we just skip
	    // as much as we can.
	    if ( (ch = in.read()) == '\r' ) {
		ch = in.read() ;
	    } 
	    return true ;
	}
	fileEnd = true ;
	return false ;
    }

    public int read()
	throws IOException 
    {
	int ch ;
	if ( partEnd )
	    return -1 ;
	switch (ch = in.read()) {
	  case '\r':
	      // check for a boundary 
	      in.mark (boundary.length) ;
	      int c1 = in.read() ;
	      int c2 = in.read() ;
	      int c3 = in.read() ;
	      if ((c1 == '\n') && (c2 == '-') && (c3 == '-')) {
		  in.read(buffer) ;
		  for (int i = 0 ; i < boundary.length ; i++) {
		      if ( buffer[i] != boundary[i] ) {
			  in.reset() ;
			  return ch ;
		      }
		  }
		  partEnd = true ;
		  if ( (ch = in.read()) == '\r' ) {
		      in.read() ;
		  } else if (ch == '-') {
		      // FIXME, check the second hyphen
		      if (in.read() == '-')
			  fileEnd = true ;
		  }
		  return -1 ;
	      } else {
		  in.reset () ;
		  return ch ;
	      }
	      // not reached
	  case -1:
	      fileEnd = true ;
	      return -1 ;
	  default:
	      return ch ;
	}
    }

    public int read (byte b[], int off, int len)
	throws IOException 
    {
	int got = 0 ;
	int ch ;

	while ( got < len ) {
	    if ((ch = (byte) read()) == -1)
		return got ;
	    b[off+(got++)] = (byte) ch ;
	}
	return got ;
    }

    public long skip (long n) 
	throws IOException 
    {
	while ((--n >= 0) && (read() != -1))
	    ;
	return n ;
    }

    public int available ()
	throws IOException
    {
	return 0 ;
    }


    public boolean nextInputStream() 
	throws IOException
    {
	if ( fileEnd ) {
	    return false ;
	}
	if ( ! partEnd ) { 
	    return skipToBoundary() ;
	} else {
	    partEnd = false ;
	    return true ;
	}
    }

    /**
     * Construct a new multipart input stream.
     * @param in The initial (multipart) input stream.
     * @param boundary The input stream MIME boundary.
     */

    public MIMEMultipartInputStream (InputStream in, byte boundary[]) {
	super (in) ;
	this.boundary = boundary ;
	this.buffer   = new byte[boundary.length] ;
	this.partEnd  = false ;
	this.fileEnd  = false ;
    }

}
