// MIMEException.java
// $Id: MIMEException.java,v 1.1 1996/04/10 13:52:12 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mime ;

/**
 * This exception is the only one that gets thrown by this package. 
 * <p>It is always provided with an informative message. There are mainly two 
 * classes of errors that can happen here:</p>
 * <dl>
 * <dt>Parsing errors</dt><dd>When the input stream doesn't conform to rfc822
 * specification.</dd>
 * <dt>Header access errors</dt><dd>When you try to access headers that 
 * doesn't exit in the given message,</dd>
 * </dl>
 * @see w3c.mime.MIMEParser
 * @see w3c.mime.MIMEHeaders
 */

public class MIMEException extends Exception {
    public MIMEException (String msg) {
	super (msg) ;
    }
    public MIMEException () {
	super() ;
    }
}
