// MIMEContentLengthInputStream.java
// $Id: MIMEContentLengthInputStream.java,v 1.1 1996/04/10 13:52:10 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mime ;

import java.io.* ;

/**
 * A MIME Input stream to deal with a specific content length. 
 * This stream will return -1 once the provided count of bytes have been read 
 * from the filtered input stream.
 */

public class MIMEContentLengthInputStream extends MIMEInputStream {
    int length = 0 ;

    public int read()
	throws IOException 
    {
	if ( --length >= 0 )
	    return in.read() ;
	return -1 ;
    }

    public int read (byte b[], int off, int len)
	throws IOException 
    {
	if ( length <= 0 )
	    return -1 ;
	if ( len > length ) 
	    len = length ;
	len     = in.read (b, off, len) ;
	length -= len ;
	return len ;
    }
    
    public long skip (long n) 
	throws IOException 
    {
	int howmany = (int) n ;
	if (howmany > length)
	    howmany = length ;
	howmany = (int) in.skip (howmany) ;
	length -= howmany ;
	return (long) howmany ;
    }

    public int available ()
	throws IOException
    {
	return length ;
    }

    /**
     * Builds a new content-length input stream.
     * This stream acts as a normal stream except that it will return 
     * an end of file, after <em>count</em> bytes have been delivered.
     */

    public MIMEContentLengthInputStream (InputStream in, int length) {
	super(in) ;
	this.length = length ;
    }

}
