// Language.java
// $Id: Language.java,v 1.1 1996/04/10 13:52:06 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mime ;

/**
 * This class is used to compare content languages. Request 
 * <em>accept-language</em> header are parsed into an array of these objects, 
 * which can be matched against some language string.
 * <p><b>FIXME</b> I should really, like for MIME types have a Language class,
 * inherited by some other AcceptLanguage, BTW MIMEType and Accept MIMEType.
 */

public class Language {
    String language ;
    double quality ;

    /**
     * Does the given language matches this one.
     * @param another The language to match.
     * @return A value indicating how well these languages match, a negative
     * value indicate that they don't match at all.
     */

    public int match (String another) {
	if ( language.equals (another) )
	    return 1 ;
	else
	    return -1 ;
    }

    /**
     * Get this language quality, should be a method of AcceptLanguage.
     * @return A quality (double) indicating how well this language is
     * accepted.
     */

    public double getQuality () {
	return quality ;
    }

    // Ugly parsing, temp FIXME

    Language (String spec) 
	throws LanguageFormatException
    {
	int start = 0 ;
	int strl  = spec.length() ;
	while ((start < strl) && (spec.charAt (start)) <= ' ')
	    start++ ;
	StringBuffer sb = new StringBuffer() ;
	// Get the language
	while ((start < strl) 
	       && (spec.charAt(start) != ';')
	       && (spec.charAt(start) >  ' ')) {
	    sb.append (spec.charAt(start++)) ;
	}
	this.language = sb.toString() ;
	// Get the quality
	int iq = spec.indexOf ("ql", 0) ;
	if ( iq < 0 ) {
	    this.quality = 1.0 ;
	} else {
	    Double d = null ;
	    try {
		d = Double.valueOf(spec.substring(iq+3,strl)) ;
	    } catch (NumberFormatException e) {
		throw new LanguageFormatException ("Invalid quality.") ;
	    }
	    this.quality = d.doubleValue() ;
	}
    }
}
