// PropStat.java
// $Id: PropStat.java,v 1.1 1996/04/10 13:51:09 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.status ;

import java.io.* ;

import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.*;
import w3c.mime.* ;

/**
 * This class implements an entity that dumps the current server properties.
 * this is just to make sure that the properties value is what you really 
 * think they are.
 */

public class PropStat extends HTTPResource {

    protected void dumpProperties (OutputStream out) {
	System.getProperties().save (out, "# Current set of properties.") ;
    }

    public Reply get (Request request) 
	throws HTTPException
    {
	ByteArrayOutputStream out = new ByteArrayOutputStream() ;
	dumpProperties (out) ;
	Reply reply = request.makeReply(HTTP.OK);
	reply.setContentType (MIMEType.TEXT_PLAIN) ;
	reply.setStream (new ByteArrayInputStream (out.toByteArray()));
	reply.setKeepConnection(false) ;
	return reply ;
    }
}
