// RelocateResource.java
// $Id: RelocateResource.java,v 1.1 1996/04/12 21:24:14 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.util.*;
import java.io.* ;

import w3c.jigsaw.http.*;

/**
 * This resource will always emit a relocation to some given URL.
 */


public class RelocateResource extends HTTPResource {
    /**
     * Attribute index - The relocation location.
     */
    protected static int ATTR_LOCATION = -1 ;

    static {
	Attribute   a = null ;
	Class     cls = null ;

	try {
	    cls = Class.forName("w3c.jigsaw.resources.RelocateResource");
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	// The location attribute
	a = new StringAttribute("location"
				, null
				, Attribute.EDITABLE|Attribute.MANDATORY) ;
	ATTR_LOCATION = AttributeRegistery.registerAttribute(cls, a) ;
    }

    /**
     * Get the location for the relocation
     */

    public String getLocation() {
	return (String) getValue(ATTR_LOCATION, null) ;
    }

    /**
     * Emit a redirect.
     * All GET requests are redirected toward the target location.
     * @param client The client issuing the request.
     * @param request The request to handle.
     * @exception HTTPException If the request couldn't be handled.
     */

    public Reply get (Request request)
	throws HTTPException
    {
	String location = getLocation() ;
	if ( location == null ) {
	    Reply error = request.makeReply(HTTP.INTERNAL_SERVER_ERROR) ;
	    error.setContent("The target RelocateResource doesn't define the"
			     + " relocation location. The server is "
			     + " misconfigured.") ;
	    throw new HTTPException(error) ;
	} else {
	    Reply reply = request.makeReply(HTTP.MOVED_TEMPORARILY) ;
	    reply.setLocation (location) ;
	    reply.setContentLength (0) ;
	    reply.setKeepConnection (false) ;
	    return reply ;
	}
    }
	
}
