// PassDirectory.java
// $Id: PassDirectory.java,v 1.1 1996/04/30 00:02:13 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.*;

/**
 * A directory resource able to pass (jump) into some non-related directory.
 * This resource provides something similar to the PASSS rule of the CERN
 * server: it allows you to export a directory that is not strictly under 
 * the server physicall space (e.g. none of its parent directory is the server
 * space directory).
 * <p>Using this resource means that your exported space is no more
 * restrained to the server space directory, which can be considered as 
 * a security problem.
 */

 
public class PassDirectory extends DirectoryResource {
    /**
     * Attribute index - The target physicall directory of this resource.
     */
    protected static int ATTR_PASSTARGET = -1 ;

    static {
	Attribute a   = null ;
	Class     cls = null ;

	// Get a pointer to our class.
	try {
	    cls = Class.forName("w3c.jigsaw.resources.PassDirectory") ;
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	// The directory attribute.
	a = new FileAttribute("pass-target"
			      , null
			      , Attribute.EDITABLE);
	ATTR_PASSTARGET = AttributeRegistery.registerAttribute(cls, a) ;
    }

    /**
     * The getDirectory method now returns the pass-directory.
     */

    public File getDirectory() {
	return (File) getValue(ATTR_PASSTARGET, null) ;
    }
}

