// LongAttribute.java
// $Id: LongAttribute.java,v 1.1 1996/04/10 13:50:06 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

/**
 * The generic description of an LongAttribute.
 */

public class LongAttribute extends Attribute {

    /**
     * Is the given object a valid LongAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof Long) || (obj == null) ;
    }
     
    /**
     * Pickle an long to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object l) 
	throws IOException
    {
	out.writeLong(((Long) l).longValue()) ;
    }

    /**
     * Unpickle an long from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of Long.
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	return new Long(in.readLong()) ;
    }
     
    public LongAttribute(String name, Long def, int flags) {
	super(name, def, flags) ;
    }

}
