// IntegerAttribute.java
// $Id: IntegerAttribute.java,v 1.1 1996/04/10 13:50:02 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

/**
 * The generic description of an IntegerAttribute.
 */

public class IntegerAttribute extends Attribute {

    /**
     * Is the given object a valid IntegerAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof Integer) || (obj == null) ;
    }
     
    /**
     * Pickle an integer to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object i) 
	throws IOException
    {
	out.writeInt(((Integer) i).intValue()) ;
    }

    /**
     * Unpickle an integer from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of Integer.
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	return new Integer(in.readInt()) ;
    }
     
    public IntegerAttribute(String name, Integer def, int flags) {
	super(name, def, flags) ;
    }

}
