// FileAttribute.java
// $Id: FileAttribute.java,v 1.1 1996/04/10 13:49:52 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

/**
 * The generic description of an FileAttribute.
 */

public class FileAttribute extends Attribute {

    /**
     * Is the given object a valid FileAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof File);
    }
     
    /**
     * Pickle an File to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object f) 
	throws IOException
    {
	out.writeUTF(((File) f).getAbsolutePath()) ;
    }

    /**
     * Unpickle an File from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of File.
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	return new File(in.readUTF()) ;
    }
     
    public FileAttribute(String name, File def, int flags) {
	super(name, def, flags) ;
    }

}
