// ContainerResource.java
// $Id: ContainerResource.java,v 1.1 1996/04/10 13:49:42 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import w3c.jigsaw.http.* ;

/**
 * The ContainerResource is a resource that can have children.
 * This resource implements the basic HTTP lookup, through a three stage 
 * process:
 * <ul>
 * <li>Given a request, create an appropriate LookupState object, that will 
 * handle the state of the lookup operation.
 * <li>Loop along the container resources we encounter, checking access
 * authorization along the way. At each step, we invoke the current target
 * lookup method with the current lookup state as a parameter.
 * <li>Return the located target resource.
 * </ul>
 * <p>Sub-classes of this class can redefine both of the lookup methods, 
 * depending on their needs (eg a proxying resource will redefine the one 
 * that takes a request as an argument, while a directory resource, will 
 * just redefine the second one).
 * <p>This class does <em>not</em> make any assumption on the actual policy
 * used to store and retreive the container childrens.
 * @see w3c.jigsaw.http.LookupState
 * @see w3c.jigsaw.resources.DirectoryResource
 */

public class ContainerResource extends HTTPResource {

    /**
     * Is the request allowed to visit this container at all ?
     * @param request The request that is being looked up.
     * @exception HTTPException If access is denied.
     */

    public void checkAccess(LookupState state) 
	throws HTTPException
    {
	return ;
    }

    /**
     * Lookup the next component of this lookup state in here.
     * @param state The current lookup state.
     * @return A resource instance, or <strong>null</strong> if no match
     *    was found.
     */

    public HTTPResource lookup(LookupState state) 
	throws HTTPException
    {
	return null ;
    }

    /**
     * Lookup the target of this request, starting from here.
     * @param request The request whose target is to be looked up.
     * @exception HTTPException If we couldn't locate the target, or parse
     *    thee requested URI.
     */

    public HTTPResource lookup(Request request) 
	throws HTTPException
    {
	LookupState       state  = new LookupState(request) ;
	HTTPResource      target = this ;
	ContainerResource casted = null ;

	// Loop until we found the appropriate target:
	while ( state.hasMoreComponents() ) {
	    if ((target == null) || ! (target instanceof ContainerResource)) {
		Reply error = request.makeReply(HTTP.NOT_FOUND) ;
		error.setContent ("<h1>Document not found</h1>"
				  + "<p>Document <b>"
				  + request.getURI("<em>invalid URI</em>")
				  + "</b> not found on this server.");
		throw new HTTPException (error) ;
	    } 
	    casted = (ContainerResource) target ;
	    casted.checkAccess(state) ;
	    target = casted.lookup(state) ;
	}
	// Check target resource:
	if ( target == null ) {
	    Reply error = request.makeReply(HTTP.NOT_FOUND) ;
	    error.setContent ("<h1>Document not found</h1>"
			      + "<p>Document <b>"
			      + request.getURI("<em>invalid URI</em>")
			      + "</b> not found on this server.");
	    throw new HTTPException (error) ;
	}
	return target ;
    }
    
}
