// ClassAttribute.java
// $Id: ClassAttribute.java,v 1.1 1996/04/10 13:49:41 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

/**
 * The generic description of an ClassAttribute.
 */

public class ClassAttribute extends Attribute {

    /**
     * Is the given object a valid ClassAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof Class);
    }
     
    /**
     * Pickle an integer to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object c) 
	throws IOException
    {
	out.writeUTF(((Class) c).getName()) ;
    }

    /**
     * Unpickle an integer from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of Integer.
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	String clsname = in.readUTF() ;
	try {
	    return Class.forName(clsname);
	} catch (Exception ex) {
	    throw new IOException ("Unable to restore class "
				   + clsname
				   + ": "
				   + ex.getMessage()) ;
	}
    }
     
    public ClassAttribute(String name, Class def, int flags) {
	super(name, def, flags) ;
    }

}
