// BooleanAttribute.java
// $Id: BooleanAttribute.java,v 1.1 1996/04/10 13:49:39 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

/**
 * The generic description of an BooleanAttribute.
 */

public class BooleanAttribute extends Attribute {

    /**
     * Is the given object a valid BooleanAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof Boolean);
    }
     
    /**
     * Pickle an boolean to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object b) 
	throws IOException
    {
	out.writeBoolean(((Boolean) b).booleanValue()) ;
    }

    /**
     * Unpickle an boolean from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of Boolean.
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	return (in.readBoolean()) ? Boolean.TRUE : Boolean.FALSE;
    }
     
    public BooleanAttribute(String name, Boolean def, int flags) {
	super(name, def, flags) ;
    }

}
