// ProxyDirectory.java
// $Id: ProxyDirectory.java,v 1.2 1996/05/28 14:33:59 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.proxy ;

import java.net.*;
import java.io.* ;

import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;

class ProxiedResource extends HTTPResource {
    ProxyDirectory directory = null ;
    URL            url       = null ;

    /**
     * Copy the given URLConnection parameters back to the reply.
     * @param conn The URLConection to get meta infos from.
     * @param reply The repy to fill in.
     */

    protected void copy(URLConnection conn, Reply reply) {
	reply.setContentLength(conn.getContentLength()) ;
	reply.setContentType(conn.getContentType()) ;
	reply.setLastModified(conn.getLastModified()) ;
    }

    /**
     * Get a proxied resource.
     * Go to the target server, and download the resource's entity.
     * @param request The request to handle.
     * @exception HTTPException If processing the request fails.
     */

    public Reply get(Request request) 
	throws HTTPException
    {
	InputStream   in   = null ;
	URLConnection conn = null ;
	long          ims  = request.getIfModifiedSince() ;

	try {
	    conn = url.openConnection() ;
	    if ( ims >= 0 )
		conn.setIfModifiedSince(ims) ;
	    in = conn.getInputStream() ;
	} catch (IOException ex) {
	    Reply error = request.makeReply(HTTP.SERVICE_UNAVAILABLE) ;
	    error.setContent("Cannot connect for "+url) ;
	    throw new HTTPException (error) ;
	}
	// Set up the reply:
	Reply reply = null ;
	if ((ims != -1) && (conn.getLastModified() <= ims)) {
	    reply = request.makeReply(HTTP.NOT_MODIFIED) ;
	    try {
		in.close() ;
	    } catch (IOException ex) {
	    }
	} else {
	    reply = request.makeReply(HTTP.OK) ;
	    copy(conn, reply) ;
	    reply.setStream(in) ;
	}
	reply.setProxy() ;
	reply.setProxyKeepConnection(true) ;
	return reply ;
    }

    ProxiedResource(ProxyDirectory directory, URL url) {
	this.directory = directory ;
	this.url       = url ;
    }

}

/**
 * A proxy module for Jigsaw.
 * This is really a proof-of-conpcept thing. It will no actually do any caching
 * right now, although plans are to use the w3c.tools.dbm package to maintain
 * a database of cached resources.
 * <p>It heavily relies on java net's library to do the client side of the
 * proxy handling, which <em>might</em> not be the right thing to do for the 
 * time being.
 */

public class ProxyDirectory extends FilteredResource {
    
    /**
     * Lookup for an proxied resource.
     * @param request The request whose URI is to be looked up.
     * @exception HTTPException If something fails.
     */

    public HTTPResource lookup(Request request)
	throws HTTPException
    {
	String  uri     = request.getURI() ;

	if ( uri.indexOf(':') < 0 ) {
	    Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
	    error.setContent("Invalid proxy request, url " 
			     + uri
			     + " doesn't specify a full URL.");
	    throw new HTTPException (error) ;
	} else {
	    // Create a suitable proxied resource:
	    URL url = null ;
	    try {
		url = new URL(request.getURI()) ;
	    } catch (MalformedURLException ex) {
		Reply error = request.makeReply(HTTP.NOT_FOUND) ;
		error.setContent("Invalid URL: "+request.getURI()) ;
		throw new HTTPException (error) ;
	    }
	    return new ProxiedResource(this, url) ;
	}
    }

    public void initialize(Object values[]) {
	super.initialize(values) ;
    }
}
