// LabelBureauFactory.java
// $Id: LabelBureauFactory.java,v 1.1 1996/04/10 13:46:55 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.pics ;

import java.io.File ;

import java.util.Hashtable ;

/**
 * This class manages label bureau creation.
 * It follows the general pattern for creating interface objects.
 */

public class LabelBureauFactory {
    private static Hashtable bureaus = new Hashtable () ;

    public static LabelBureauInterface getLabelBureau (File identifier) {
	SampleLabelBureau b = (SampleLabelBureau) bureaus.get (identifier) ;
	if ( b == null ) {
	    b =  new SampleLabelBureau (identifier) ;
	    bureaus.put (identifier, b) ;
	}
	return b ;
    }

}
