// Extension.java
// $Id: Extension.java,v 1.1 1996/04/10 13:45:36 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.indexer ;

import java.util.*;
import java.io.* ;

import w3c.jigsaw.resources.* ;

/**
 * Extension description, for the indexer.
 */

public class Extension extends IndexerResource {
    private static Class CLASS = null ;

    static {
	try {
	    CLASS = Class.forName("w3c.jigsaw.resources.HTTPResource") ;
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
    }

    /**
     * Get the default target class.
     */

    public Class getDefaultTargetClass() {
	return CLASS ;
    }

    /**
     * Create an extension object.
     * @param ext The described extension.
     * @param cls The class to be used for default resources wrapping files
     *    having this extension.
     * @return An initialized extension object.
     */

    static Extension makeExtension (String ext, Class cls) {
	Extension extension = new Extension() ;
	Hashtable defs      = new Hashtable(3) ;
	defs.put("identifier", ext) ;
	if ( cls != null )
	    defs.put("class", cls) ;
	extension.initialize(defs) ;
	return extension ;
    }

}
