// Directory.java
// $Id: Directory.java,v 1.1 1996/04/10 13:45:35 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.indexer ;

import java.util.*;
import java.io.* ;

import w3c.jigsaw.resources.* ;

/**
 * Directory description objects.
 * Those objects are template that allows the server to know how to index
 * new directories on the fly, through the resourceIndexer.
 * @see ResourceIndexer
 */


public class Directory extends IndexerResource {
    private static Class CLASS = null ;

    /**
     * Attribute index - Does this applies to directory below this one.
     */
    protected static int ATTR_GENERIC = -1 ;

    static {
	Attribute a = null ;
	Class     cls = null ;
	try {
	    cls   = Class.forName("w3c.jigsaw.indexer.Directory") ;
	    CLASS = Class.forName("w3c.jigsaw.resources.DirectoryResource");
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	// The generic flag
	a = new BooleanAttribute("generic"
				 , Boolean.FALSE
				 , Attribute.EDITABLE) ;
	ATTR_GENERIC = AttributeRegistery.registerAttribute(cls, a) ;
    }

    /**
     * Get the default directory target class.
     */

    public Class getDefaultTargetClass() {
	return CLASS ;
    }

    /**
     * Get the generic flag value.
     */

    public boolean getGenericFlag() {
	return getBoolean(ATTR_GENERIC, false) ;
    }

    /**
     * Create a new Directory template.
     */

    public static Directory makeDirectory(String name, Class cls) {
	Directory template = new Directory() ;
	Hashtable defs      = new Hashtable(3) ;
	defs.put("identifier", name) ;
	if ( cls != null )
	    defs.put("class", cls) ;
	template.initialize(defs) ;
	return template ;
    }

}

