// httpdStatistics.java
// $Id: httpdStatistics.java,v 1.1 1996/04/29 23:57:45 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http;

/**
 * This class maintains server wide statistics about hits.
 * This class should probably be coded as a resource itself, and made 
 * accessible through a specific HTTPResource. I am just having fun 
 * for the time being.
 */


public class httpdStatistics {
    protected httpd server = null ;

    /**
     * The min processing time in ms.
     */
    protected long r_min = Long.MAX_VALUE ;
    /**
     * The URL that has been processed the fastest.
     */
    protected String u_min = null ;
    /**
     * The maximum processing time in ms.
     */
    protected long r_max = 0 ;
    /**
     * The URL that has been processed the slowest.
     */
    protected String u_max = null ;
    /**
     * The total number of hits.
     */
    protected long t_hits  = 0 ;
    /**
     * The total number of emited bytes.
     */
    protected long t_bytes = 0 ;
    /**
     * The total time spent in processing requests in ms.
     */
    protected long t_req = 0 ;
     
    /**
     * Update the current statistics with the given request.
     * @param client The client that processed the request.
     * @param request The request that has been processed.
     * @param nbytes The number of emited bytes in reply's body.
     * @param duration The processing time of the request.
     */

    protected synchronized void updateStatistics(Client client
						 , Request request, Reply reply
						 , int nbytes
						 , long duration) {
	if ( duration > r_max ) {
	    r_max = duration ;
	    u_max = request.getURI() ;
	}
	if ( duration < r_min ) {
	    r_min = duration ;
	    u_min = request.getURI() ;
	}
	t_req   += duration ;
	t_bytes += nbytes ;
	t_hits++ ;
    }

    /**
     * Get the total number of hits.
     * @return The total number of processed requests since the server is up.
     */
    
    public long getHitCount() {
	return t_hits ;
    }

    /**
     * Get the mean request processing time.
     * @return The average time to process a request.
     */

    public long getMeanRequestTime() {
	return (t_hits > 0) ? t_req / t_hits : -1 ;
    }

    /**
     * Get the max request processing time.
     * @return A long giving the maximum duration for a request.
     */

    public long getMaxRequestTime() {
	return r_max ;
    }

    /**
     * Get the URL of the request that took the longest time to be processed.
     * @return A String giving the URL of the corresponding request, or
     *    <strong>null</strong> if no request has been processed yet.
     */

    public String getMaxRequestURL() {
	return u_max ;
    }

    /**
     * Get the min request processing time.
     * @return A long giving the minimum request processing time.
     */

    public long getMinRequestTime() {
	return r_min ;
    }

    /**
     * Get the URL of the request that took the smallest time to be processed.
     * @return A String giving the URL of the corresponding request, or
     *    <strong>null</strong> if no request has been processed yet.
     */

    public String getMinRequestURL() {
	return u_min ;
    }

    /**
     * Get the total number of bytes emited.
     * @return A long giving the total number of bytes emited by the server.
     *    This count that not include the reply's header, but only the reply's
     *    body (or <em>entity</em> size).
     */

    public long getEmitedBytes() {
	return t_bytes ;
    }

    httpdStatistics (httpd server) {
	this.server = server ;
    }

}
