// HTTPException.java
// $Id: HTTPException.java,v 1.1 1996/04/10 13:44:37 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http ;

import w3c.mime.MIMEException ;

/**
 * All entities should throw an HTTPException when encoutering some problems.
 * This kind of exception is the one that gets normally caught by clients,
 * and result in sending back HTTP error messages to the client.
 */

public class HTTPException extends Exception {
    String msg   = null ;
    Reply  error = null ;
    
    /**
     * Was a reply provided with the exception ?
     * @return True if a reply is available.
     */

    public boolean hasReply () {
	return error != null  ;
    }

    /**
     * Get this exception reply.
     * @return The reply to send back to requesting process.
     */

    public Reply getReply() {
	return error ;
    }

    public HTTPException (String msg) {
	super (msg) ;
	this.error = null ;
    }

    public HTTPException (String msg, Reply error) {
	super (msg) ;
	this.error = error ;
    }
    public HTTPException (Reply error) {
	super ((String) null) ;
	this.error = error ;
    }
}

	
