// Bag.java
// $Id: Bag.java,v 1.1 1996/04/10 13:44:30 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http ;

import java.util.* ;

/**
 * Internal representation of protocol headers conforming to the bag spec.
 * The <strong>bag</strong> specification is part of the Protocol Extension
 * Protocol defined by w3c, it can be found
 * <a href="http://www.w3.org/hypertext/WWW/TR/WD-http-pep.html>here</a>.
 */

public class Bag {
    String    name  = null ;
    Hashtable items = null ;

    /**
     * Get this bag names
     * @return The name of this bag.
     */

    public String getName() {
	return name ;
    }

    /**
     * Add a named bag into this bag.
     * @param bag The bag to add (in case item is a bag).
     */

    public void addBag (Bag subbag) {
	items.put (subbag.getName(), subbag) ;
    }

    /**
     * Does this bag have a named sub-bag of the given name ?
     * @param name The name of the sub-bag to be tested for.
     * @return <strong>true</strong> if this sub-bag exists.
     */

    public boolean hasBag (String name) {
	Object item = items.get (name) ;
	if ( (item != null) && (item instanceof Bag) )
	    return true ;
	return false ;
    }

    /**
     * Get a named sub-bag from this bag.
     * @param name The name of the sub-bag to get.
     * @return A bag instance, or <strong>null</strong> if none was found.
     */

    public Bag getBag (String name) {
	if (hasBag (name))
	    return (Bag) items.get (name) ;
	return null ;
    }

    /**
     * Add an item into this bag.
     * @param name The new item name.
     */

    public void addItem (String name) {
	items.put (name, Boolean.TRUE) ;
    }

    /**
     * Does this bag contains the given item, being a bag or a simple word.
     * @param name The name of the item to test.
     * @return <strong>true</strong> if the bag contains the given item, 
     *   <strong>false</strong> otherwise.
     */

    public boolean hasItem (String name) {
	return items.get (name) != null ;
    }

    /**
     * Get all named items from this bag. 
     * This include both named sub-bags and items by their own.
     */

    public Enumeration keys () {
	return items.keys() ;
    }

    Bag (String name) {
	this.name  = name ;
	this.items = new Hashtable (3) ;
    }
}
