// RadioBoxField.java
// $Id: RadioBoxField.java,v 1.1 1996/04/10 13:42:06 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

import w3c.jigsaw.html.HtmlGenerator ;

public class RadioBoxField extends FormField {
    int cursor = -1 ;
    String options[] = null ;

    /**
     * Get this field's value.
     * @return A string giving the name of the selected option.
     */

    public Object getValue() {
	return options[cursor] ;
    }

    /**
     * Set this field's value to the given option.
     * @param nval The option name.
     * @return A boolean, <strong>true</strong> if the field was set.
     * @exception FormFieldException If the field doesn't have such an option.
     */

    public boolean setValue(String nval)
	throws FormFieldException
    {
	for (int i = 0 ; i < options.length ; i++) {
	    if (options[i].equals(nval)) {
		cursor = i ;
		return true ;
	    }
	}
	throw new FormFieldException ("invalid option: " +nval) ;
    }

    /**
     * Dump this field into a suitable HTML element.
     * @param into The HtmlGenerator to dump the field to.
     */

    public void dump(HtmlGenerator into) {
	dumpTitle(into) ;
	into.append("<th align=left>");
	for (int i = 0 ; i < options.length ; i++) {
	    into.append(options[i]
			+ "<input type=\"radio\" name=\"" 
			+ name 
			+ "\" value=\"" + options[i] +"\">") ;
	}
	into.append("</th>");
    }

    /**
     * The RadioBoxField doesn't support the initialize interface.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */

    public void initialize(String name, String title, String url, Object val) 
	throws FormFieldException
    {
	String msg = "RadioBoxField doesn't support the initialize interface.";
	throw new FormFieldException(msg);
    }

    public RadioBoxField(String name, String title, String url
			 , String options[], int ival) {
	super(name, title, url) ;
	this.options = options ;
	this.cursor  = ival ;
    }

}
