// IndexerResourceEditor.java
// $Id: IndexerResourceEditor.java,v 1.1 1996/04/10 13:43:29 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.formedit ;

import java.util.* ;

import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.forms.* ;
import w3c.jigsaw.formedit.*;
import w3c.jigsaw.indexer.*;
import w3c.jigsaw.html.*;

class IndexerResourceEditorHandler extends FormCardHandler {
    IndexerResource target = null ;

    public void notifyChange(FormFieldInterface field, Object value) 
	throws FormFieldException
    {
	target.setTargetValue(field.getName(), value) ;
    }

    public String notifyEndProcessing(FormCardResource card, Request request)
	throws FormProcessingException
    {
	return "..";
    }

    IndexerResourceEditorHandler(IndexerResource target) {
	this.target = target ;
    }

}

public class IndexerResourceEditor extends GenericResourceEditor {

    /**
     * dump some header for the form.
     */

    public void dumpTitle(HtmlGenerator into) {
	IndexerResource target = (IndexerResource) getTarget() ;
	Class           cls    = target.getTargetClass() ;
	if ( cls == null )
	    cls = target.getDefaultTargetClass() ;
	into.append("<h2>"+cls.getName()+"</h2>");
    }

    /**
     * Define th card to edit our target indexer resource.
     */

    protected void defineCards() {
	IndexerResource  target = (IndexerResource) getTarget() ;
	super.defineCards() ;
	// The shadow attribute card:
	FormCardResource card   = null ;
	card = defineCard(new IndexerResourceEditorHandler(target) 
			  , "ShadowedAttributes"
			  , "Shadowed attributes of "
			  + target.getIdentifier()) ;
	Attribute attrs[] = target.getTargetAttributes() ;
	for (int i = 0 ; i < attrs.length ; i++) {
	    Attribute              a = attrs[i] ;
	    FormFieldInterface field = null ;

	    if ( ! a.checkFlag(Attribute.EDITABLE) )
		continue ;
	    field = FormFieldRegistery.getTargetField(target, a) ;
	    if ( field != null )
		card.addField(field) ;
	}
    }

    /**
     * Initialize an indexer resource editor.
     */

    public void initialize(Object values[]) {
	super.initialize(values) ;
	// Check our target, define form card.
	if ( ! definesAttribute(ATTR_TARGET) ) 
	    throw new AttributeHolderInitException("no target to edit.");
    }

}

