// GenericFilterEditor.java
// $Id: GenericFilterEditor.java,v 1.2 1996/04/12 20:59:48 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.formedit ;

import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.forms.*;

class FilterAttributeHandler extends FormCardHandler {
    ResourceFilter      filter = null ;
    GenericFilterEditor editor = null ;
    boolean             done   = false ;

    public void notifyButtonClick(String label) {
	if ( label.equals("Remove") ) {
	    done = true ;
	    editor.removeFilter(filter) ;
	}
    }

    public void notifyChange(FormFieldInterface field, Object value) 
	throws FormFieldException
    {
	filter.setValue(field.getName(), value) ;
    }

    FilterAttributeHandler(GenericFilterEditor editor, ResourceFilter filter) {
	this.editor = editor ;
	this.filter = filter ;
    }
}

class FilterTargetAttributeHandler extends FormCardHandler {
    ResourceFilter filter = null ;

    public void notifyChange(FormFieldInterface field, Object value) 
	throws FormFieldException
    {
	filter.setTargetValue(field.getName(), value) ;
    }

    FilterTargetAttributeHandler(ResourceFilter filter) {
	this.filter = filter;
    }

}

public class GenericFilterEditor implements FormEditorHelper {
    ResourceFilter target = null ;
    FormResource   form   = null ;

    public void removeFilter (ResourceFilter filter) {
	FilteredResource r = (FilteredResource) filter.getTargetResource();
	r.unregisterFilter(filter) ;
	form.removeFormCard(filter.getClass().getName()) ;
	form.removeFormCard("ShadowBy"+filter.getClass().getName()) ;
    }

    public void generateFormCard(Resource target, FormResource form) {
	FormCardResource   card  = null ;
	FormFieldInterface field = null ;

	this.target = (ResourceFilter) target ;
	this.form   = form ;
	// Generate the card for the filter's attribute:
	Class            cls     = target.getClass() ;
	Attribute        attrs[] = AttributeRegistery.getClassAttributes(cls) ;
	card    = form.defineCard(new FilterAttributeHandler(this, this.target)
				  , cls.getName()
				  , cls.getName()) ;
	for (int i = 0 ; i < attrs.length ; i++) {
	    Attribute a = attrs[i] ;
	    if ( ! a.checkFlag(Attribute.EDITABLE) )
		continue ;
	    field = FormFieldRegistery.getField(target, attrs[i]);
	    if ( field != null ) 
		card.addField(field) ;
	}
	card.addButton("Remove") ;
	// generate the cards for the potentially shadowed target attrs:
	card = form.defineCard(new FilterTargetAttributeHandler(this.target) 
			       , "ShadowBy"+target.getClass().getName()
			       , "Attributes shadowed by "
			       + target.getClass().getName()) ;
	Resource filtered = this.target.getTargetResource() ;
	cls   = filtered.getClass() ;
	attrs = AttributeRegistery.getClassAttributes(cls) ;
	for (int i = 0 ; i < attrs.length ; i++) {
	    Attribute a = attrs[i] ;
	    if ( ! a.checkFlag(Attribute.EDITABLE) )
		continue ;
	    field = FormFieldRegistery.getTargetField((ResourceShadower)target
						      , attrs[i]) ;
	    if ( field != null )
		card.addField(field) ;
	}
    }

}
