// DirectoryResourceEditor.java
// $Id: DirectoryResourceEditor.java,v 1.2 1996/04/19 22:50:52 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html


package w3c.jigsaw.formedit;

import java.util.*;
import java.net.*;

import w3c.tools.sorter.*;
import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.forms.*;
import w3c.mime.*;

class DirectoryAddHandler extends FormCardHandler {
    DirectoryResource target = null ;

    public void notifyButtonClick(String label) {
	target.save() ;
    }

    public String notifyEndProcessing(FormCardResource card, Request request)
	throws FormProcessingException
    {
	String name = (String) card.lookupField("name").getValue() ;
	Class  cls  = (Class) card.lookupField("class").getValue() ;
	if ((name == null) || (cls == null)) {
	    String msg = "Fill in the name of the extension, and the class " 
                + " that files having this extension should be exported " 
                + " with." ; 
            throw new FormProcessingException (msg) ; 
	} 
	// Create and register the new resource:
	try {
	    Hashtable    defs     = new Hashtable(11);
	    HTTPResource resource = (HTTPResource) cls.newInstance() ;
	    target.registerResource(name, resource, defs);
	} catch (Exception ex) {
	    ex.printStackTrace();
	    throw new FormProcessingException ("Unable to create "
					       + name
					       + ": "
					       + ex.getMessage());
	}
	return null;
    }

    DirectoryAddHandler(DirectoryResource target) {
	this.target = target ;
    }

}

class DirectoryListHandler extends FormCardHandler {
    protected static String commands[] = { "Update", "Remove", "Reindex" } ;

    protected DirectoryResource  target     = null ;
    protected long               card_stamp = -1 ;
    protected FormFieldInterface command    = null ;

    /**
     * The list of marked resources to act on.
     */
    Vector marked = null ;
    /**
     * The command to run on the marked reosurces.
     */
    protected String runcmd = null ;

    /**
     * Update the directory list card if needed.
     * @param card The card to be updated.
     */

    public FormCardResource updateFormCard(FormCardResource card) {
	// Check if the card is still valid ?
	if ( card_stamp >= target.getLastModified() ) 
	    return card ;
	card.reset() ;
	// 
	URL   targeturl = null ;
	String edurl    = null ;
	try {
	    targeturl = new URL(target.getURL()) ;
	    edurl     = ".." + targeturl.getFile();
	} catch (Exception ex) {
	    edurl = null ;
	}
	// Generate the whole list of existing resources:
	FormFieldInterface field     = null ;
	Enumeration        enum      = target.enumerateResourceIdentifiers() ;
	Vector             resources = Sorter.sortStringEnumeration(enum) ;
	for (int i = 0 ; i < resources.size() ; i++) {
	    String name = (String) resources.elementAt(i) ;
	    field = new CheckBoxField(name
				      , name
				      , edurl +"/" + name
				      , false) ;
	    card.addField(field) ;
	}
	// Generate the command radio box:
	command = new RadioBoxField("Command", "Command", null, commands, 0);
	card.addField(command) ;
	card_stamp = target.getLastModified() ;
	return card ;
    }


    /**
     * Notify that some field value has changed.
     * We jut maintain here the list of resources to act on. Remember that
     * by default, the <code>notify...</code> method calls are atomic
     * (they can't overlap).
     * @param field The field that changed.
     * @param value Its new value.
     */

    public void notifyChange(FormFieldInterface field, Object value) {
	// Is it the command ?
	if ( field == command ) {
	    this.runcmd = (String) value ;
	} else {
	    // One of our resources, mark it:
	    if ( marked == null )
		marked = new Vector() ;
	    marked.addElement(field.getName()) ;
	}
    }
     
    /**
     * Process the card.
     * @param card The card to be processed.
     * @param request The request that triggered the request.
     * @exception FormProcessingException If the processing failed.
     */

    public String notifyEndProcessing(FormCardResource card, Request request)
	throws FormProcessingException
    {
	// Check that we did get a command to run:
	if ( runcmd == null ) {
	    throw new FormProcessingException("You haven't selected a command"
					      +" from the appropriate command"
					      +" field.");
	}
	// Run the command:
	try {
	    if ( runcmd.equals("Remove") ) {
		// Remove all marked resources:
		for (int i = 0 ; i < marked.size() ; i++) 
		    target.unregisterResource((String) marked.elementAt(i));
	    } else if ( runcmd.equals("Update") ) {
		// Update all children resources...
		for (int i = 0 ; i < marked.size() ; i++) {
		    String       name = (String) marked.elementAt(i) ;
		    HTTPResource res  = target.lookup(name) ;
		    if ( res != null )
			res.updateAttributes() ;
		}
	    } else if ( runcmd.equals("Reindex") ) {
		// Reindex marked resources:
		for (int i = 0 ; i < marked.size() ; i++) {
		    String name = (String) marked.elementAt(i) ;
		    target.unregisterResource(name) ;
		    target.createDefaultResource(name) ;
		}
	    } else {
		// Unknwon command !
		System.out.println("Unknown command: "+runcmd) ;
	    }
	} finally {
	    marked.setSize(0) ;
	    runcmd = null ;
	}
	return null ;
    }

    /**
     * Create a directory list handler object.
     */
    
    DirectoryListHandler(DirectoryResource target) {
	this.target = target ;
    }

}


public class DirectoryResourceEditor extends FilteredResourceEditor {
    DirectoryResource target = null ;

    public DirectoryResource getTargetDirectory() {
	return (DirectoryResource) super.getTarget() ;
    }

    /**
     * Defines the card to add brand new resources.
     * This card allows to add new resources to a directory. If the directory
     * isn't extensible, than this is the only way to add new resources.
     * Otherwise, you can also use the laziness of the direrctory resource
     * to create file resource on demand.
     */

    protected void defineDirectoryAddCard() {
	DirectoryResource   target  = getTargetDirectory() ;
	DirectoryAddHandler handler = new DirectoryAddHandler(target) ;
	FormCardResource    card    = defineCard(handler
						 , "AddingResources"
						 , "Adding resources in "
						 + target.getIdentifier()) ;
	FormFieldInterface field = null ;
	// The name of the resource:
	field = new TextField("name", "name", null, null);
	card.addField(field);
	// THe class for the new resource:
	field = new ClassnameField("class", "class", null, null) ;
	card.addField(field);
	// A (yuk) save button
	card.addButton("Save");
    }

    /**
     * Current list of resources for the directorty.
     * This card will list the available children resources, and provide
     * commands to update or delete them.
     */

    protected void defineDirectoryListCard() {
	DirectoryResource    target  = getTargetDirectory() ;
	DirectoryListHandler handler = new DirectoryListHandler(target) ;
	FormCardResource     card    = defineCard(handler
						  , "ExistingResources"
						  , "Existing resources of "
						  + target.getIdentifier());
	handler.updateFormCard(card) ;
    }
	    
    protected void defineCards() {
	// Define the generic cards:
	super.defineCards() ;
	// Define the card to list directory content:
	defineDirectoryListCard() ;
	// define the card to define new resources
	defineDirectoryAddCard() ;
    }
	
}
