// CvsEntryEntity.java
// $Id: CvsEntryResource.java,v 1.1 1996/04/10 13:39:44 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.cvs;

import java.io.* ;

import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.*;
import w3c.mime.MIMEType ;
import w3c.jigsaw.html.HtmlGenerator ;
import w3c.cvs.* ;

/**
 * This class exports the state of an entry. For the time being it doesn't
 * do much, but it should act as a directory (container) for all revisions
 * of a document. 
 * <p>The lookup method of this entity should be able to turn a revision number
 * into an editable (or viewable) document.
 */

public class CvsEntryResource extends FilteredResource {
    CvsEntry entry = null ;

    public Resource lookup (String name) {
	return this ;
    }

    protected Reply dolog (Request request)
	throws HTTPException
    {
	String log = null ;
	try {
	    log = entry.log () ;
	} catch (CvsException e) {
	    Reply error = request.makeReply(HTTP.INTERNAL_SERVER_ERROR) ;
	    HtmlGenerator g = new HtmlGenerator ("CVS log command failed") ;
	    g.append ("<p>The CVS <strong>log</strong> command failed "
		      + " on " + entry.getName()
		      + " with the following error message: "
		      + "<em>" + e.getMessage() + "</em>"
		      + "<hr> from class: " + this.getClass().getName()) ;
	    error.setStream (g) ;
	    throw new HTTPException (error) ;
	}
	Reply reply = request.makeReply(HTTP.OK) ;
	reply.setContentType (MIMEType.TEXT_PLAIN) ;
	reply.setContent (log) ;
	return reply ;
    }

    protected Reply dodiff (Request request)
	throws HTTPException
    {
	String diff = null ;
	try {
	    diff = entry.diff () ;
	} catch (CvsException e) {
	    Reply error = request.makeReply(HTTP.INTERNAL_SERVER_ERROR) ;
	    HtmlGenerator g = new HtmlGenerator ("CVS diff command failed") ;
	    g.append ("<p>The CVS <strong>diff</strong> command failed "
		      + " on " + entry.getName()
		      + " with the following error message: "
		      + "<em>" + e.getMessage() + "</em>"
		      + "<hr> from class: " + this.getClass().getName()) ;
	    error.setStream (g) ;
	    throw new HTTPException (error) ;
	}
	Reply reply = request.makeReply(HTTP.OK) ;
	reply.setContent (diff) ;
	reply.setContentType (MIMEType.TEXT_PLAIN) ;
	return reply ;
    }

    /**
     * Getting an entry entity start with dumping the log for this entity
     * which (should) act as a directory for all versions of it.
     */

    public Reply get (Request request)
	throws HTTPException
    {
	if ( ! request.hasField("query") ) {
	    Reply error = request.makeReply(HTTP.INTERNAL_SERVER_ERROR);
	    error.setContent("Invalid query field.");
	    throw new HTTPException (error) ;
	}
	String cmd = request.getQueryString() ;
	if ( cmd.equalsIgnoreCase("log") ) {
	    return dolog(request) ;
	} else if ( cmd.equalsIgnoreCase ("diff")) {
	    return dodiff(request) ;
	} else {
	    Reply error = request.makeReply(HTTP.INTERNAL_SERVER_ERROR) ;
	    error.setContent ("Unknown command: "+cmd) ;
	    throw new HTTPException(error) ;
	}
    }

    CvsEntryResource (CvsEntry entry) {
	this.entry = entry ;
    }
}
