// CvsDirectoryHandler.java
// $Id: CvsDirectoryHandler.java,v 1.1 1996/04/10 13:39:38 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.cvs ;

import w3c.cvs.* ;
import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.html.HtmlGenerator ;

public class CvsDirectoryHandler implements CvsDirectoryHandlerInterface {
    CvsDirectory cvs = null ;

    /**
     * Perform the action on the given entity.
     * @param action The action to perform.
     * @param entry The entry on which the action shold should be performed.
     * @exception HTTPException If running the action failed.
     */

    public void perform (Request request, String action, CvsEntry entries[]) 
	throws HTTPException
    {
	try {
	    if ( action.equals ("add") ) {
		cvs.add ("no-comment", entries) ;
	    } else if ( action.equals ("remove") ) {
		cvs.remove (entries) ;
	    } else if ( action.equals ("update") ) {
		cvs.update (entries) ;
	    } else if ( action.equals ("commit") ) {
		cvs.commit ("no-comment", entries) ;
	    } else if ( action.equals ("refresh") ) {
		cvs.refresh () ;
	    } else {
		Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
		HtmlGenerator g = new HtmlGenerator ("Bad CVS command") ;
		g.append ("<p>Your command "
			  + "<strong>"+ action + "</strong>"
			  + " wasn't undesrtood."
			  + "<hr>" + this.getClass().getName()) ;
		error.setStream (g) ;
		throw new HTTPException (error) ;
	    }
	} catch (CvsException e) {
	    e.printStackTrace() ;
	    Reply error = request.makeReply(HTTP.INTERNAL_SERVER_ERROR) ;
	    HtmlGenerator g = new HtmlGenerator ("CVS command failed") ;
	    g.append ("<p>Your cvs command "
		      + "<strong>" + action + "</strong>"
		      + " failed with the following error message: </p>"
		      + "<em>" + e.getMessage() + "</em>"
		      + "<hr>" + this.getClass().getName()) ;
	    error.setStream (g) ;
	    throw new HTTPException (error) ;
	}
    }

    /**
     * Perform the action on the given entity.
     * @param action The action to perform.
     * @param entry The entry on which the action shold should be performed.
     * @param comment A string of comments describing the change.
     * @exception HTTPException If running the action failed.
     */

    public void perform (Request request
			 , String action, CvsEntry entries[]
			 , String comment) 
	throws HTTPException
    {
	try {
	    if ( action.equals ("add") ) {
		cvs.add (comment, entries) ;
	    } else if ( action.equals ("remove") ) {
		cvs.remove(entries) ;
	    } else if ( action.equals ("update") ) {
		cvs.update(entries) ;
	    } else if ( action.equals ("commit") ) {
		cvs.commit (comment, entries) ;
	    } else if ( action.equals ("refresh") ) {
		cvs.refresh() ;
	    } else {
		Reply error = request.makeReply(HTTP.BAD_REQUEST) ;
		HtmlGenerator g = new HtmlGenerator ("Bad CVS command") ;
		g.append ("<p>Your command "
			  + "<strong>"+ action + "</strong>"
			  + " wasn't undesrtood."
			  + "<hr>" + this.getClass().getName()) ;
		error.setStream (g) ;
		throw new HTTPException (error) ;
	    }
	} catch (CvsException e) {
	    e.printStackTrace() ;
	    Reply error = request.makeReply(HTTP.INTERNAL_SERVER_ERROR) ;
	    HtmlGenerator g = new HtmlGenerator ("CVS command failed") ;
	    g.append ("<p>Your cvs command "
		      + "<strong>" + action + "</strong>"
		      + " failed with the following error message: </p>"
		      + "<em>" + e.getMessage() + "</em>"
		      + "<hr>" + this.getClass().getName()) ;
	    error.setStream (g) ;
	    throw new HTTPException (error) ;
	}
    }

    CvsDirectoryHandler(CvsDirectory cvs) {
	super() ;
	this.cvs = cvs ;
    }
}
