       PAGE    ,80 ; P       View in Code Page 437,850,852,853,857,860,865!
; #############################################################################
;
;    EUROFONT V1.02 Eurocurrency bitmap definitions for display and printing
;
;    Copyright (C) 1998-2000 by Matthias Paul 
;                               Ubierstrae 28
;                               D-50321 Brhl
;                               GERMANY
;
;    All rights reserved (except those detailed below).
;
;    Registered trademarks and tradenames mentioned inhere are owned
;    by their respective owners.
;
;    If you use these shapes in other software, or have additional bitmaps
;    in use, please let me know.
;
;    mailto:<Matthias.Paul@post.rwth-aachen.de>
;
;    http://www.rhrz.uni-bonn.de/~uzs180/mpdokeng.html
;    http://www.freedos.org/
;    http://www.ibiblio.org/pub/micro/pc-stuff/freedos/files/util/print/cpi/
;
;    Last edit: 2000-11-05 MPAUL
;
; #############################################################################
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program (see LICENSE.TXT or http://www.gnu.org);
;    if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
;    Cambridge, MA 02139, USA.
;
; #############################################################################
;
;    History:
;    ========
;
;    EUROFONT.INC 1.02 2000-11-05 MPAUL
;    Improved comments, and added notes regarding the Eurocurrency
;    representation in various charsets.
;    Added EURO_PRN_18_12_NLQ, and a number of control sequences and
;    Eurocurrency transscriptions.
;
;    EUROFONT.INC 1.01 2000-10-25 MPAUL
;    For compatibility with INT 10h character recognition in graphics mode,
;    I modified the display bitmaps to be 100% compatible with the shapes
;    provided by PC DOS 2000 (EGA.CPI as of 1998-06-01).  For reference,
;    the old bitmaps are available under alternative "_OBSOLETE" names, now.
;    Thereby I also incorporated the shapes developed for 24 dot matrix
;    printers as used by my NECPINW.CPI since 2000-09-28, and the 16x8
;    bitmap used by Aitor Santamara's EURO/EUROTSR (under GPL version 2),
;    so that the EUROFONT.INC may serve for reference and identification
;    purposes for any kind of Eurocurrency bitmaps.
;    I put this file unter GNU GPL version 2 to include it in my NECPINW.ZIP
;    distribution, and for possible use with FreeDOS and Linux.  Although
;    I prefer open source, I still personally reserve the right to continue
;    to use these bitmaps in any kind of closed sourced software, would this
;    become necessary (e.g. for a possibly future DR-DOS).
;
;    EUROFONT.INC 1.00 1998-05-01 MPAUL
;    Display and printer bitmaps originally created for inclusion with
;    DR-DOS 7.02+, but for some reason they were only used internally and
;    never made it into the distributed EGA.CPI files.
;    Please note, that these bitmaps were independently developed by me
;    (not Caldera), so you are free to use them in your software without
;    worrying about any copyright infringements.
;
; #############################################################################
;
;    To Do List:
;    ===========
;
;    - Shape for ROM display fonts organized  32 bytes per character
;    - Download RAM font shapes for 48 dot ink printers
;    - Download RAM font shapes for high resolution ink and laser printers
;    - Shapes for all kinds of printers in their various graphical modes
;      (including Daisy Wheel single dot graphics mode ;-)
;
; #############################################################################
;
;    Regarding the Eurocurrency representation in various character sets:
;    ====================================================================
;
;    With PC DOS 2000 (and PC DOS 7 updates since 1998-06-01) IBM introduced
;    the Eurocurrency symbol U20ACh (EURO SIGN) in Code Page 850 at code
;    point D5h replacing the U0131h (LATIN SMALL LETTER DOTLESS I) previously
;    residing at this location.  Fortunately, Code Page 850 provides a glyph
;    for U00B9h (SUPERSCRIPT ONE) at code point FBh, which looks very similar
;    to the previous glyph at code point D5h.  So, converting existing files
;    shouldn't be too difficult.  I still find the modification of an
;    approved and widely used standard quite surprisingly, in particular
;    since IBM usually assigns new Code Page IDs and CCSIDs when changing
;    any definitions in Code Pages (beyond just additions).
;
;    NB. I can see only one reason for their decision: Due to a fixed buffer
;        allocation the PC DOS/MS-DOS IBMBIO.COM/IO.SYS is limited to handle
;        only a few hundred Country-Code Page entries in a COUNTRY.SYS files.
;        (For example MS-DOS 6 uses a 6 Kb buffer for up to 438 entries, and
;        older issues seem to have used only a 2 Kb buffer for up to 146
;        entries.  Similar things should apply to PC DOS as well.)
;        Adding entries for a third supported Code Page (like ID 8501)
;        for almost all countries could have caused this COUNTRY.SYS file
;        scanner to run out of space...
;        NLSFUNC does not have this limitation, and the problem is also
;        unknown to the file scanners implemented with DR-DOS (they have
;        a 64 Kb file size limitation, though).  Increasing the buffer's
;        size shouldn't have been too difficult...
;
;    The Code Page 850 found in MS-DOS (up to 7.10 - Windows 98 SE/ZA),
;    DR-DOS (up to 7.05), PTS-DOS (up to 2000) etc. does *not* contain the
;    Eurocurrency symbol at this location (although internally DR-DOS 7.02+
;    is prepared to provide the Eurocurrency symbol since 1998-05-01... ;-).
;
;    Instead of modifying Code Page 850, a new derivative Code Page should
;    be introduced for this PC DOS 2000 variant of Code Page 850.  In lack
;    of any currently published proposal by one of the "Big Players", my
;    proposal for this variant is ID 8501, which is not currently in use
;    by IBM "Character Data Representation Architecture Reference and
;    Registry" (CDRA) level 2 (as of 1995-11-14), which is still active
;    at the time of this writing (2000-11-01).
;
;    The Eurocurrency symbol has also been added to a number of other
;    Code Pages since 1998: Code Pages 874 (revision 1998-04-15), 936
;    (at least since revision 2000-01-07, not with revision 1998-04-15),
;    1250 (revision 1998-04-15), 1252 (revision 1998-04-15), 1254 (revision
;    1998-04-15), 1255 (revision 1998-04-15), 1256 (revision 1998-04-15),
;    1257 (revision 1998-04-15), 1258 (revision 1998-04-15) present
;    the symbol at code point 80h and Code Page 1251 (revision 1998-04-15)
;    has it at code point 88h.  Code Page 949 (at least since revision
;    2000-01-07, not with revision 1998-04-15) has it at code point A2E6h
;    and Code Page 950 (at least since 2000-01-07, not with 1998-04-15)
;    has it at A3E1h.
;
;    The FreeDOS EUROTSR.EXE 0.9 BETA 1 utility by Aitor Santamara (Spain)
;    redefines the character at 9Fh by the Eurocurrency symbol regardless
;    of the currently active Code Page.  This is incompatible with Code Page
;    850 etc. when the "French Franc" symbol etc. is still needed.
;
;    NB. Since the "French Franc" symbol is also used in other (even
;        non-European Union) countries as (part of) a currency symbol,
;        I think it would be better to replace a different glyph. The
;        code point 9Fh is called U0192h (LATIN SMALL LETTER F WITH HOOK) in
;        Unicode, and in some locales it has the semantic of "Small script f"
;        or "Floretin/Florette???", and thus will continue to exist even
;        after the French Franc will have ceased to be after the European
;        Monetary Union (EMU).
;        Here are my pre-liminary proposals (RFC):  Variants of Code Pages
;        437, 860, and 865 could have the U20A7h (PESETA SIGN) at code point
;        9Eh replaced by the Eurocurrency symbol, variants of Code Page 850
;        and Code Page 857 could both use code point D5h (which is undefined
;        in Code Page 857).  I have no clear opinion on Code Page 853 (maybe
;        code point EEh, which still appears to be undefined, but is used for
;        U3B5h (GREEK SMALL LETTER EPSILON) in many other Code Pages - after
;        all, when the Eurocurrency symbol was originally designed, it was
;        inspired by the Epsilon in the Greek writing of "Europa" (one of
;        Zeus' women in Greek mythology, and "founder" of the European
;        continent).  Variants of Code Pages 852 (at code point CFh) and
;        866 (at code point FDh) could have the U00A4h (CURRENCY SIGN)
;        replaced by the Eurocurrency symbol.  I have no good idea for a
;        variant of Code Page 863, maybe 98h (CURRENCY SIGN), or EEh, too???
;
;    Anyway, for immediate compatibility with EUROTSR, my NECPINW.CPI 2.02+
;    adapts the EUROTSR proposal for variants of Code Pages 437, 667/991,
;    850, 863, and 865.  These are all the Code Pages in the supported
;    range, which have the "French Franc" symbol at code point 9Fh.
;    The Code Page variants are made available in the IBM CDRA level 2
;    user definable CCSID range E000h..EFFFh under IDs 58805, 59035,
;    59218, 59231, 59233, and 59359.  Would EUROTSR switch to use
;    different code points, NECPINW.CPI should also be updated to the
;    new assignments.
;
;    NECPINW.CPI 2.00+ provides the PC DOS 2000 variant of Code Page 850
;    under ID 8501 and in the IBM CDRA user definable range under ID 58194.
;    Variants of this Code Page in various type sets are available under IDs
;    65392, 65393, 65394, 65395, 65396, 65397, 65398, 65401, 65402, 65403,
;    65404, and 65405.  These IDs are in the "private use" CPGID range
;    FF00h..FFFEh reserved by IBM CDRA level 2.  Please note, that all these
;    non-standard assignments are subject to change.
;
;    For additional info on Code Pages please refer to my CPI???.ZIP package.
;
; #############################################################################

BS      equ     08h                     ; backspace
ESC_    equ     1Bh                     ; escape sequence lead-in

; --- Eurocurrency bitmaps for display ----------------------------------------

EURO_6x8        macro
        db      00011100b               ;  1 NB. - This Eurocurrency shape is
        db      00100010b               ;  2       only a proposal for a 6x8
        db      01111000b               ;  3       display font.
        db      01110000b               ;  4     - It may also be used by
        db      00100010b               ;  5       future DR-DOS 7.0x+ files.
        db      00011100b               ;  6     - To be viewed horizontally!
        endm

EURO_6x8_OBSOLETE macro
        db      00111000b               ;  1 NB. - This shape was added to
        db      01000100b               ;  2       the DR-DOS 7.02/7.03 font
        db      11110000b               ;  3       database on 1998-05-01.
        db      11100000b               ;  4     - It was replaced by EURO_6x8
        db      01000100b               ;  5       on 2000-10-25.
        db      00111000b               ;  6     - To be viewed horizontally!
        endm

; -----------------------------------------------------------------------------

EURO_8x8        macro
        db      00011110b               ;  1 NB. - This shape is designed to
        db      00100001b               ;  2       be compatible with the shape
        db      01111100b               ;  3       provided by PC DOS 2000
        db      00100000b               ;  4       EGA.CPI (1998-06-01) for
        db      01111100b               ;  5       Code Page 850 character D5h.
        db      00100001b               ;  6     - It may also be used by
        db      00011110b               ;  7       future DR-DOS 7.0x+ files.
        db      00000000b               ;  8     - To be viewed horizontally!
        endm

EURO_8x8_OBSOLETE macro
        db      00111100b               ;  1 NB. - This shape was added to
        db      01000010b               ;  2       the DR-DOS 7.02/7.03 font
        db      11111000b               ;  3       database on 1998-05-01.
        db      01000000b               ;  4     - It was replaced by EURO_8x8
        db      11111000b               ;  5       on 2000-10-25.
        db      01000010b               ;  6     - To be viewed horizontally!
        db      00111100b               ;  7
        db      00000000b               ;  8
        endm

; -----------------------------------------------------------------------------

EURO_14x8       macro
        db      00000000b               ;  1 NB. - This shape is designed to
        db      00000000b               ;  2       be compatible with the shape
        db      00000000b               ;  3       provided by PC DOS 2000
        db      00011110b               ;  4       EGA.CPI (1998-06-01) for
        db      00110011b               ;  5       Code Page 850 character D5h.
        db      01100000b               ;  6     - It may also be used by
        db      11111110b               ;  7       future DR-DOS 7.0x+ files.
        db      01100000b               ;  8     - To be viewed horizontally!
        db      11111100b               ;  9
        db      01100000b               ; 10
        db      00110011b               ; 11
        db      00011110b               ; 12
        db      00000000b               ; 13
        db      00000000b               ; 14
        endm

EURO_14x8_OBSOLETE macro
        db      00000000b               ;  1 NB. - This shape was added to
        db      00000000b               ;  2       the DR-DOS 7.02/7.03 font
        db      00111100b               ;  3       database on 1998-05-01.
        db      01100010b               ;  4     - It was replaced by EURO_14x8
        db      01000000b               ;  5       on 2000-10-25.
        db      11111100b               ;  6     - To be viewed horizontally!
        db      01000000b               ;  7
        db      11111000b               ;  8
        db      01000000b               ;  9
        db      01100010b               ; 10
        db      00111100b               ; 11
        db      00000000b               ; 12
        db      00000000b               ; 13
        db      00000000b               ; 14
        endm

; -----------------------------------------------------------------------------

EURO_16x8       macro
        db      00000000b               ;  1 NB. - This shape is designed to
        db      00000000b               ;  2       be compatible with the shape
        db      00000000b               ;  3       provided by PC DOS 2000
        db      00011110b               ;  4       EGA.CPI (1998-06-01) for
        db      00110011b               ;  5       Code Page 850 character D5h.
        db      01100000b               ;  6     - It may also be used by
        db      11111110b               ;  7       future DR-DOS 7.0x+ files.
        db      01100000b               ;  8     - To be viewed horizontally!
        db      11111100b               ;  9
        db      01100000b               ; 10
        db      00110011b               ; 11
        db      00011110b               ; 12
        db      00000000b               ; 13
        db      00000000b               ; 14
        db      00000000b               ; 15
        db      00000000b               ; 16
        endm

EURO_16x8_OBSOLETE macro
        db      00000000b               ;  1 NB. - This shape was added to
        db      00000000b               ;  2       the DR-DOS 7.02/7.03 font
        db      00000000b               ;  3       database on 1998-05-01.
        db      00111100b               ;  4     - It was replaced by EURO_16x8
        db      01100010b               ;  5       on 2000-10-25.
        db      01000000b               ;  6     - To be viewed horizontally!
        db      11111100b               ;  7
        db      01000000b               ;  8
        db      11111000b               ;  9
        db      01000000b               ; 10
        db      01100010b               ; 11
        db      00111100b               ; 12
        db      00000000b               ; 13
        db      00000000b               ; 14
        db      00000000b               ; 15
        db      00000000b               ; 16
        endm

EURO_16x8_OBSOLETE2 macro
        db      00000000b               ;  1 00h NB. - This shape was used
        db      00000000b               ;  2 00h       by Aitor Santamara's
        db      00011110b               ;  3 1Eh       EUROTSR extension
        db      00100001b               ;  4 21h       0.9 BETA (2000-05-07)
        db      01000001b               ;  5 41h       for FreeDOS.
        db      01000000b               ;  6 40h     - It should be replaced
        db      11111110b               ;  7 FEh       by EURO_16x8!
        db      01000000b               ;  8 40h     - To be viewed
        db      11111100b               ;  9 FCh       horizontally!
        db      01000000b               ; 10 40h
        db      01000000b               ; 11 40h
        db      00100001b               ; 12 21h
        db      00011110b               ; 13 1Eh
        db      00000000b               ; 14 00h
        db      00000000b               ; 15 00h
        db      00000000b               ; 16 00h
        endm

; -----------------------------------------------------------------------------

EURO_19x8       macro
        db      00000000b               ;  1 NB. - This Eurocurrency shape is
        db      00000000b               ;  2       only a proposal for a 19x8
        db      00000000b               ;  3       display font.
        db      00000000b               ;  4     - To be viewed horizontally!
        db      00011110b               ;  5
        db      00110011b               ;  6
        db      01100000b               ;  7
        db      11111110b               ;  8
        db      01100000b               ;  9
        db      01100000b               ; 10
        db      11111100b               ; 11
        db      01100000b               ; 12
        db      00110011b               ; 13
        db      00011110b               ; 14
        db      00000000b               ; 15
        db      00000000b               ; 16
        db      00000000b               ; 17
        db      00000000b               ; 18
        db      00000000b               ; 19
        endm

EURO_19x16_LE   macro
        dw      0000000000000000b       ;  1 NB. - This Eurocurrency shape is
        dw      0000000000000000b       ;  2       only a proposal for a 19x16
        dw      0000000000000000b       ;  3       display font.
        dw      0000000000000000b       ;  4     - It is the same as the 19x8
        dw      0000001111111100b       ;  5       font but with all the bits
        dw      0000111100001111b       ;  6       doubled intentiously.
        dw      0011110000000000b       ;  7     - The order of bytes is
        dw      1111111111111100b       ;  8       Little Endian (Intel style).
        dw      0011110000000000b       ;  9     - To be viewed horizontally!
        dw      0011110000000000b       ; 10
        dw      1111111111110000b       ; 11
        dw      0011110000000000b       ; 12
        dw      0000111100001111b       ; 13
        dw      0000001111111100b       ; 14
        dw      0000000000000000b       ; 15
        dw      0000000000000000b       ; 16
        dw      0000000000000000b       ; 17
        dw      0000000000000000b       ; 18
        dw      0000000000000000b       ; 19
        endm

EURO_19x16_BE   macro
        db      00000000b,00000000b     ;  1 NB. - This Eurocurrency shape is
        db      00000000b,00000000b     ;  2       only a proposal for a 19x16
        db      00000000b,00000000b     ;  3       display font.
        db      00000000b,00000000b     ;  4     - It is the same as the 19x8
        db      00000011b,11111100b     ;  5       font but with all the bits
        db      00001111b,00001111b     ;  6       doubled intentiously.
        db      00111100b,00000000b     ;  7     - The order of bits is
        db      11111111b,11111100b     ;  8       Big Endian (Motorola style).
        db      00111100b,00000000b     ;  9     - To be viewed horizontally!
        db      00111100b,00000000b     ; 10
        db      11111111b,11110000b     ; 11
        db      00111100b,00000000b     ; 12
        db      00001111b,00001111b     ; 13
        db      00000011b,11111100b     ; 14
        db      00000000b,00000000b     ; 15
        db      00000000b,00000000b     ; 16
        db      00000000b,00000000b     ; 17
        db      00000000b,00000000b     ; 18
        db      00000000b,00000000b     ; 19
        endm

; --- Eurocurrency bitmaps for printing ---------------------------------------

EURO_PRN_8x11_Draft macro
                                        ;               1
                                        ;      12345678901
                                        ;
                                        ;  1   00101010100   Bit 7
                                        ;  2   01000000010    |
                                        ;  3   10101010000    |
                                        ;  4   01000000000    |
                                        ;  5   10101010000    |
                                        ;  6   01000000010    |
                                        ;  7   00101010100    |
                                        ;  8 _ 00000000000 _ Bit 0
                                        ;
        db      00101000b               ;  1 NB. - This Eurocurrency shape was
        db      01010100b               ;  2       added to the DR-DOS 7.02+
        db      10101010b               ;  3       printer font database on
        db      00000000b               ;  4       1998-05-01.
        db      10101010b               ;  5     - It is designed for 9 dot
        db      00000000b               ;  6       matrix printers such as the
        db      10101010b               ;  7       Epson FX-850/FX-1050 and
        db      00000000b               ;  8       Epson compatible printers.
        db      10000010b               ;  9       It can also be used for
        db      01000100b               ; 10       9 dot and 18 dot matrix
        db      00000000b               ; 11       printers such as the
        endm                            ;          IBM Proprinter Model 4201 &
                                        ;          XL Model 4202 in Draft mode.
                                        ;        - For print head hardware
                                        ;          reasons, no two horizontally
                                        ;          adjacent needles may be
                                        ;          set at the same time!
                                        ;        - To be viewed vertically!

; -----------------------------------------------------------------------------

EURO_PRN_18x12_NLQ macro
                                        ;               1
                                        ;      123456789012
                                        ;
                                        ;  1 v 000000000000 v Byte 1 Bit 7
                                        ;  2   000010101000           |
                                        ;  3   000100000100           |
                                        ;  4   001000000010           |
                                        ;  5   001000000000           |
                                        ;  6   001000000000           |
                                        ;  7   010101010100           |
                                        ;  8   001000000000   Byte 1 Bit 0
                                        ;  9   001000000000   Byte 2 Bit 7
                                        ; 10   010101010000           |
                                        ; 11   001000000000           |
                                        ; 12   001000000000           |
                                        ; 13   001000000010           |
                                        ; 14   000100000100           |
                                        ; 15   000010101000           |
                                        ; 16   000000000000   Byte 2 Bit 0
                                        ; 17   000000000000   Byte 3 Bit 7
                                        ; 18 _ 000000000000 _ Byte 3 Bit 6
        ;  Byte 1     Byte 2     Byte 3
        db 00000000b, 00000000b, 00000000b ;  1 NB. - This shape is designed
        db 00000010b, 01000000b, 00000000b ;  2       for 9 dot and 18 dot
        db 00011101b, 10111000b, 00000000b ;  3       matrix printers in
        db 00100010b, 01000100b, 00000000b ;  4       18 dot NLQ mode, like
        db 01000000b, 00000010b, 00000000b ;  5       like most Epson 9 dot
        db 00000010b, 01000000b, 00000000b ;  6       and 18 dot matrix
        db 01000000b, 00000010b, 00000000b ;  7       printers and compatibles.
        db 00000010b, 01000000b, 00000000b ;  8     - For print head hardware
        db 01000000b, 00000010b, 00000000b ;  9       reasons, no two
        db 00100010b, 00000100b, 00000000b ; 10       horizontally adjacent
        db 00010000b, 00001000b, 00000000b ; 11       needles may be set at
        db 00000000b, 00000000b, 00000000b ; 12       the same time!
        endm                               ;        - To be viewed vertically!

; -----------------------------------------------------------------------------

EURO_PRN_16x23_NLQ macro
                        ;               1         2
                        ;      12345678901234567890123
                        ;
                        ;  1 v 00000000000000000000000 v Byte 1 Bit 7
                        ;  2   00000000111111110000000   Byte 2 Bit 7
                        ;  3   00000011000000001100000   Byte 1 Bit 6
                        ;  4   00000100000000000010000   Byte 2 Bit 6
                        ;  5   00000100000000000000000   Byte 1 Bit 5
                        ;  6   00001000000000000000000   Byte 2 Bit 5
                        ;  7   00111111111111111000000   Byte 1 Bit 4
                        ;  8   00001000000000000000000   Byte 2 Bit 4
                        ;  9   00001000000000000000000   Byte 1 Bit 3
                        ; 10   00111111111111100000000   Byte 2 Bit 3
                        ; 11   00001000000000000000000   Byte 1 Bit 2
                        ; 12   00000100000000000000000   Byte 2 Bit 2
                        ; 13   00000100000000000010000   Byte 1 Bit 1
                        ; 14   00000011000000001100000   Byte 2 Bit 1
                        ; 15   00000000111111110000000   Byte 1 Bit 0
                        ; 16 _ 00000000000000000000000 _ Byte 2 Bit 0

        ;  Byte 1     Byte 2
        db 00000000b, 00000000b         ;  1 NB. - This Eurocurrency shape was
        db 00000000b, 00000000b         ;  2       added to the DR-DOS 7.02+
        db 00010000b, 00001000b         ;  3       printer font database on
        db 00010000b, 00001000b         ;  4       1998-05-01.
        db 00011100b, 00111000b         ;  5     - It is designed for 9 dot
        db 00110010b, 01001100b         ;  6       matrix printers which use
        db 01010000b, 00001010b         ;  7       16 dots for 18 dot NLQ like
        db 01010000b, 00001010b         ;  8       IBM Proprinter Model 4201 &
        db 00010001b, 10001000b         ;  9       XL Model 4202 as well as
        db 00010001b, 10001000b         ; 10       Star printers.
        db 00010001b, 10001000b         ; 11     - To be viewed vertically with
        db 00010001b, 10001000b         ; 12       the two bytes interwoven
        db 00010001b, 10001000b         ; 13       on a bit-by-bit basis!
        db 00010001b, 10001000b         ; 14     - Some printers (like the
        db 00010001b, 10001000b         ; 15       Star LC-10) may still
        db 00010001b, 10000000b         ; 16       require that there are no
        db 01010000b, 00000010b         ; 17       horizontally adjacent dots,
        db 01000000b, 00000010b         ; 18       but this appears to be don't
        db 00000010b, 01000000b         ; 19       care for the IBM printers.
        db 00000000b, 00000000b         ; 20       Any experiences?
        db 00000000b, 00000000b         ; 21
        db 00000000b, 00000000b         ; 22
        db 00000000b, 00000000b         ; 23
        endm

; -----------------------------------------------------------------------------

EURO_PRN_24x9_Draft macro
                                        ;      123456789
                                        ;
                                        ;  1   000000000   1 Byte 1 Bit 7
                                        ;  2   000000000   2         |
                                        ;  3   000000000   3         |
                                        ;  4 v 000000000 v 4         |
                                        ;  5   000000000             |
                                        ;  6   000010100             |
                                        ;  7   000101010             |
                                        ;  8   001000001     Byte 1 Bit 0
                                        ;  9   010000000     Byte 2 Bit 7
                                        ; 10   101010100             |
                                        ; 11   101010000             |
                                        ; 12   010000000             |
                                        ; 13   010000000             |
                                        ; 14   101010100             |
                                        ; 15   101010000             |
                                        ; 16   010000000     Byte 2 Bit 0
                                        ; 17   001000001     Byte 3 Bit 7
                                        ; 18   000101010             |
                                        ; 19   000010100             |
                                        ; 20 ^ 000000000 ^ 4         |
                                        ; 21   000000000   3         |
                                        ; 22   000000000   2         |
                                        ; 23   000000000   1         |
                                        ; 24 _ 000000000 _   Byte 3 Bit 0

        ; Byte: 1    2    3
        db      00h, 66h, 00h           ;  1 NB. - This Eurocurrency shape
        db      00h, 99h, 00h           ;  2       is used by my NECPINW.CPI
        db      01h, 66h, 80h           ;  3       since 2.00+ (2000-09-28).
        db      02h, 00h, 40h           ;  4     - It is designed for 24 dot
        db      04h, 66h, 20h           ;  5       matrix printers such as
        db      02h, 00h, 40h           ;  6       the NEC Pinwriter family
        db      04h, 44h, 20h           ;  7       in Draft modes.
        db      02h, 00h, 40h           ;  8     - For print head hardware
        db      01h, 00h, 80h           ;  9       reasons, no two horizontally
        endm                            ;          adjacent needles may be
                                        ;          set at the same time!
                                        ;        - To be viewed vertically!

; -----------------------------------------------------------------------------

EURO_PRN_24x22_LQ macro
                        ;               1         2
                        ;      1234567890123456789012
                        ;
                        ;  1   0000000000000000000000   1 Byte 1 Bit 7
                        ;  2   0000000000000000000000   2         |
                        ;  3   0000000000000000000000   3         |
                        ;  4 v 0000000000000000000000 v 4         |
                        ;  5   0000000000000000000000             |
                        ;  6   0000000000101010000000             |
                        ;  7   0000000101010101010000             |
                        ;  8   0000010100000000010100     Byte 1 Bit 0
                        ;  9   0000101000000000000101     Byte 2 Bit 7
                        ; 10   1010101010101010000000             |
                        ; 11   0101010101010000000000             |
                        ; 12   0010100000000000000000             |
                        ; 13   0010100000000000000000             |
                        ; 14   1010101010101000000000             |
                        ; 15   0101010101000000000000             |
                        ; 16   0000101000000000000101     Byte 2 Bit 0
                        ; 17   0000010100000000010100     Byte 3 Bit 7
                        ; 18   0000000101010101010000             |
                        ; 19   0000000000101010000000             |
                        ; 20 ^ 0000000000000000000000 ^ 4         |
                        ; 21   0000000000000000000000   3         |
                        ; 22   0000000000000000000000   2         |
                        ; 23   0000000000000000000000   1         |
                        ; 24 _ 0000000000000000000000 _   Byte 3 Bit 0

        ; Byte: 1    2    3
        db      00h, 44h, 00h           ;  1 NB. - This Eurocurrency shape
        db      00h, 22h, 00h           ;  2       is used by my NECPINW.CPI
        db      00h, 5Ch, 00h           ;  3       since 2.00+ (2000-09-28).
        db      00h, 22h, 00h           ;  4     - It is designed for 24 dot
        db      00h,0DDh, 00h           ;  5       matrix printers such as
        db      01h, 22h, 80h           ;  6       the NEC Pinwriter family
        db      00h,0C5h, 00h           ;  7       in LQ modes (e.g. Elite).
        db      03h, 22h,0C0h           ;  8     - For print head hardware
        db      00h, 44h, 00h           ;  9       reasons, no two horizontally
        db      02h, 22h, 40h           ; 10       adjacent needles may be
        db      04h, 44h, 20h           ; 11       set at the same time!
        db      02h, 20h, 40h           ; 12     - To be viewed vertically!
        db      04h, 44h, 20h           ; 13
        db      02h, 00h, 40h           ; 14
        db      04h, 40h, 20h           ; 15
        db      02h, 00h, 40h           ; 16
        db      00h, 00h, 00h           ; 17
        db      03h, 00h,0C0h           ; 18
        db      00h, 00h, 00h           ; 19
        db      01h, 81h, 80h           ; 20
        db      00h, 00h, 00h           ; 21
        db      00h, 81h, 00h           ; 22
        endm

; -----------------------------------------------------------------------------

EURO_PRN_24x28_LQ macro ;               1         2
                        ;      1234567890123456789012345678
                        ;
                        ;  1   0000000000000000000000000000   1 Byte 1 Bit 7
                        ;  2   0000000000000000000000000000   2         |
                        ;  3   0000000000000000000000000000   3         |
                        ;  4 v 0000000000000000000000000000 v 4         |
                        ;  5   0000000000000000000000000000             |
                        ;  6   0000000000001010101010000000             |
                        ;  7   0000000001010101010101010000             |
                        ;  8   0000000101000000000000010100     Byte 1 Bit 0
                        ;  9   0000010100000000000000000101     Byte 2 Bit 7
                        ; 10   1010101010101010101000000000             |
                        ; 11   0101010101010101000000000000             |
                        ; 12   0001010000000000000000000000             |
                        ; 13   0001010000000000000000000000             |
                        ; 14   1010101010101010100000000000             |
                        ; 15   0101010101010100000000000000             |
                        ; 16   0000010100000000000000000101     Byte 2 Bit 0
                        ; 17   0000000101000000000000010100     Byte 3 Bit 7
                        ; 18   0000000001010101010101010000             |
                        ; 19   0000000000001010101010000000             |
                        ; 20 ^ 0000000000000000000000000000 ^ 4         |
                        ; 21   0000000000000000000000000000   3         |
                        ; 22   0000000000000000000000000000   2         |
                        ; 23   0000000000000000000000000000   1         |
                        ; 24 _ 0000000000000000000000000000 _   Byte 3 Bit 0

        ; Byte: 1    2    3
        db      00h, 44h, 00h           ;  1 NB. - This Eurocurrency shape
        db      00h, 22h, 00h           ;  2       is used by my NECPINW.CPI
        db      00h, 44h, 00h           ;  3       since 2.00+ (2000-09-28).
        db      00h, 3Ah, 00h           ;  4     - It is designed for 24 dot
        db      00h, 44h, 00h           ;  5       matrix printers such as
        db      00h,0BBh, 00h           ;  6       the NEC Pinwriter family
        db      00h, 44h, 00h           ;  7       in LQ modes (e.g. Pica).
        db      01h,0A3h, 80h           ;  8     - For print head hardware
        db      00h, 44h, 00h           ;  9       reasons, no two horizontally
        db      03h, 22h,0C0h           ; 10       adjacent needles may be
        db      00h, 44h, 00h           ; 11       set at the same time!
        db      02h, 22h, 40h           ; 12     - To be viewed vertically!
        db      04h, 44h, 20h           ; 13
        db      02h, 22h, 40h           ; 14
        db      04h, 44h, 20h           ; 15
        db      02h, 20h, 40h           ; 16
        db      04h, 44h, 20h           ; 17
        db      02h, 00h, 40h           ; 18
        db      04h, 40h, 20h           ; 19
        db      02h, 00h, 40h           ; 20
        db      04h, 00h, 20h           ; 21
        db      02h, 00h, 40h           ; 22
        db      00h, 00h, 00h           ; 23
        db      03h, 00h,0C0h           ; 24
        db      00h, 00h, 00h           ; 25
        db      01h, 81h, 80h           ; 26
        db      00h, 00h, 00h           ; 27
        db      00h, 81h, 00h           ; 28
        endm

; -----------------------------------------------------------------------------

; Eurocurrency control sequences for printing (and some display terminals)

EURO_PRN_SEQ macro
        db      'C',BS,'='              ; NB. - Equal sign over 'C'
        endm                            ;     - Should be supported by all
                                        ;       Daisy Wheel printers (e.g.
                                        ;       Diablo)
EURO_PRN_PCL macro
        db      'C',ESC_,'&a-1C','='    ; NB. - Equal sign over 'C'
        endm                            ;     - Supported by HP PCL printers
                                        ;       such as all LaserJet printers,
                                        ;       including LaserJet+, LaserJet
                                        ;       500, and LaserJet 500+.

EURO_DISP_ANSI macro                    ; NB. - Equal sign over opening bracket
        db       '(',ESC_,'[1D','='     ;     - Supported by ANSI 3.64 terminals
        endm                            ;       which support superimposed
                                        ;       characters (that is, *not* by
                                        ;       PCs using ANSI.SYS in text mode)

EURO_DISP_ASCII macro                   ; NB. - Equal sign over opening bracket
        db       '(',ESC_,'D','='       ;     - Some ASCII terminals may
        endm                            ;       support this, if they support
                                        ;       superimposed characters.

; -----------------------------------------------------------------------------

; Eurocurrency transscriptions

EURO_TRANS_SEQ macro                    ;
        db      'EUR'                   ; 3-char ISO 4217 currency code
        endm                            ;

ECU_TRANS_SEQ macro                     ;
        db      'XEU'                   ; 3-char ISO 4217 currency code
        endm                            ;

EURO_TRANS_SEQ_OBSOLETE macro           ; Was used by DR-OpenDOS 7.02 and
        db      '(='                    ; DR-DOS 7.02 COUNTRY.SYS for the
        endm                            ; Eurocurrency, but was replaced
                                        ; by EURO_TRANS_SEQ for DR-DOS 7.03.

; #############################################################################

; End of file                           ; 

