
PG 1.06                                                 PG 1.06


NAME
        PG -- PaGer
        A simple text file viewer with FreeDOS



SYNOPSIS
        PG [/?] [filename]
            /?       - display a brief help screen
            filename - page through filename on the PC screen
                     - filename maybe in wildcard format
            if filename is omitted, shows the PG usage


DESCRIPTION
        PG is a text file viewer presented by the FreeDOS.
        It browses any text file and with more useful features now.


COMMAND
        Control is intuitive, Keys defined as:

        PG Key      Meaning
        ======      =======
        Esc,Q,q     exit program
        Up          scroll down 1 line
        Down,Enter  scroll up 1 line
        Page Up     scroll down 1 page
        Page Down   scroll up 1 page
        Home        first page
        End         last page
        Left        pan view left 10 columns
        Right       pan view right 10 columns (max. 50)
        1..5        save page to boomark #1..5
        Alt1..Alt5  jump to saved bookmark
        /           search text from top line
        ?           Jump to a line as far as possible
        F1          Online help
        F2          continue to search backward
        F3          continue to search forward
        F4          save 1 screenful of text to "PG.SAV"
        F9          Previous file
        F10         Next file


        Bookmarks #1..5
            As you're viewing a text file, press any of the numeric
            keys 1..5 (under the Function keys), for instance, pressing
            '1' will save the top position of the file you're viewing to
            bookmark #1. Later on, when you want to return to the place
            where you left bookmark #1, just press 'Alt' and '1' brings
            you back no matter how far you've been.
            Bookmark #1 can be updated whenever you press '1' again.
            The same is true to other bookmark keys.

        '/' Search text
            To start a search, just press the '/' key, you're prompted
            to input a string, then hit the enter key to let it go.
            The search start from the top line of your screen, then
            to next line and so on.  If the string is found, the
            line number of the string found appears behind the
            search string.  If it is not found, nothing happens.
            Press '/' again means to start a new search.

        ?   Jump to line
            Prompt you to enter a line number, then jump as far
            as possible.  Line number will be the top line and
            displayed at the end of the top status line.

        F1  Show user a brief help about the keys

        F2  continues to search backward for the next occurrence,
            the line number appears at the bottom status line if
            the search is successful. It disappears if the search
            failed.

        F3  continues to search forward for the next occurrence,
            the line number appears at the bottom status line if
            the search is successful. It disappears if the search
            failed.

        F4  Save screen to "PG.SAV"
            When we're are viewing a file, sometimes, we want to get
            an extract from the source instead of retyping. PG helps
            us to save a screenful of text as we press the 'F4' key,
            a message looks "!!! copy from filename line # !!!" will
            prepend the text we want to copy, and the file "PG.SAV",
            we need to tell PG which drive to save, just once.

        F9  Previous file
            To view the previous file from the list.

        F10 Next file
            To view the next file from the list.



COPYING
        This file and other related programs stored in PG105.ZIP are
        distributed under the terms of the GNU General Public License.
        See the file COPYING for details. And read the author's
        "Legal stuff" as written in the comments of the program
        source file.


What's new is version 1.06
        - overcome to file size limitation;
        - updated user manual;


Other features
        - view panning
        - bookmarks
        - save screen to a save file;
        - jump to line;
        - online help;
        - multiple files viewing;
        - exclude certain file formats;
        - view very large file;


PACKAGE (version 1.06) PG106.ZIP
        PG.C        - C source program
        PG.H        - C header
        PG.MAN      - manual (this file)
        PG.EXE      - the program
        PGASM.ASM   - assembly subroutines
        PG.MAK      - make file for Turbo C 2.01
        NEWS        - anouncement
        TO_DO       - job list
        COPYING     - copyright



INSTALL PG (version 1.06)

        To compile PG you need to have:
        1. Borland Turbo C 2.01
        2. Nasm 0.98.xx

        Type:
            tcc -c pg.c
            nasm -f obj pgasm.asm -o pgasm.obj
            tlink lib\c0s pg pgasm,pg,,lib\cs

        This will generate the PG.EXE program.


        or
            d:\>make -fpg.mak -Dtc=Turbo_C_Directory


        Should you get any error, check if the path is correct
        in "PG.MAK".  Also read message from previous maintainer
        at the last section of this manual.


Programming Resources

        PG 1.06 -- Turbo C with Nasm
          Borland Turbo C 2.01
          NASM 0.98
          Insight 1.10

        Turbo C 2.01 is available at the Borland Software Museum.
          http://community.borland.com/museum/

        Nasm 0.98.xx is available at
          http://nasm.sourceforge.net/

        Insight 1.10
          http://www.freedos.org/


Limitations
        ?


Author  Bill Weinmen
        E-mail: wew@bearnet.com

Maintainer  BAHCL
        version 1.02  1.03  1.04  1.05  1.06
        E-mail: freedos_pg@yahoo.com.hk


Messages from the maintainer:

        After version 1.03, PG is migrated to Borland Turbo C 2.01
        for these reasons:
        1. conform to ANSI C standard
        2. long integer support
        3. better programming environment for development
        4. easier to debug (not so true!)
        5. extracted assembly subroutines are usable by other programs
        6. I failed to compile PG with an earlier version of Micro-C.
           The version of DDS Micro-C version 3.22 I once downloaded
           disappears in the internet, I doubt if Dave Dunfield has
           stopped offering version 3.22 as a freeware.

        So, after version 1.03, I'll stop using Micro-C to maintain PG.

        PG 1.04 is a experimental version, some of its problems are
        solved now.

        PG has been revamped drastically, please note:
        1. PG 1.05 uses conventional memory to store its data now.
        2. PG 1.05 excludes certain files with extensions like
           BIN,COM,EXE,SYS,ZIP..., as these files cannot be displayed
           properly with PG.
        3. PG 1.06 has overcome all obstacles left over in previous
           version.


BAHCL



Messages from previous PG maintainer(s):

============================================================
I have made a few changes to the source, but didn't (technically)
delete anything.  I removed the verbose GNU License statement in the
usage() function.  To put it back in, add this to the code:

   #define SHOW_GNU_COPYING

or, compile like this:

  cc pg.c -fop SHOW_GNU_COPYING=1

============================================================
I have set the default behavior of the program to operate in
mono-mode only.  This is a color scheme that should work well on all
monitors, even a mono display.  To build using Bill's original
colors, add this to the code:

   #define USE_COLOR_MODE

or, compile like this:

  cc pg.c -fop USE_COLOR_MODE=1



============================================================
(Jim Hall, jhall1@isd.net)


