; ****************************************************************************
; `generic' - Generic Master Bootstrap loader (GMBLDR)
;   Written by Michal H. Tyc
;
; This file is part of `BOOTMGR - multi-BOOT ManaGeR'.
;
; Copyright (c) 1997-2006 BTTR Software.  All rights reserved.
;
; This program is free software; you can redistribute it and/or modify it
; under the terms of the `MODIFIED' BSD LICENSE.  Please see `legal.txt'
; for details.
; ****************************************************************************
; This file is normally %include'd into the main file (bootmgr.asm), but it
; can be assembled separately as well, to create an MBR image file with
; default BOOTMGR settings (no bootable partitions defined).
; ****************************************************************************


; Equates and macros.

%ifndef VERSIONDATE    ; already defined if this file is %include'd
  %include 'defs.inc'  ; no need to read common definitions again
%endif


; This code will be placed at the beginning of master boot record.
; It is loaded by ROM BIOS Initial Program Loader at linear address 7c00h
; and then run.
; Note: this address is not officially guaranteed to be expressed as
; 0:7c00h (in other words, cs on entry must be treated as unknown).

; Boot sectors of bootable partitions are also loaded at this location,
; so this code must be relocated first to another address
; (traditionally it is 0:600h or 60h:0, we choose the former).

mbrgen:
  xor cx, cx
  cli              ; disable interrupts
  mov ss, cx       ;   while switching stack (ss = 0)
  mov sp, LOADADR  ; stack just below the code
  sti
  mov es, cx
  mov ds, cx       ; ds = es = 0
  mov si, sp
  mov di, RELOC
  push si          ; push return address for runbootgen
  mov ch, 1        ; 256 words
  cld              ; string direction UP from here
  rep movsw        ; relocate MBR code

; Newer BIOSes report boot drive number in dl.
; We check and save it to allow the loader to work on HD0, HD1, and so on.

  mov al, [475h]  ; number of hard disks in system
  or al, 80h
  cmp dl, al      ; check boot drive: allowed 80h to (7fh + [475h])
  jl .hdok        ; drive number ok (signed: 80h < 81h < ... < 0 < ... < 7fh)
  mov dl, 80h     ; force HD1 if BIOS reports garbage
.hdok:
  add [RELOC + inittext.hd - mbrgen], dl  ; update startup message

; Go to relocated start.

  jmp 0:(RELOC + startgen - mbrgen)


; Start the boot loader.
; On entry:
;   dl = boot drive number
;   cx = 0

startgen:
  mov si, RELOC + inittext - mbrgen
  call printmsg             ; `HDn: '
  mov cl, 4                 ; number of partitions
  mov bx, RELOC + PARTTABL
.ta:
  cmp [bx], ch                      ; ch = 0
  mov si, bx
  jl .af                            ; active partition found
  jne .bad                          ; garbage in PT?
  add bx, byte 16
  loop .ta                          ; continue searching
  mov si, RELOC + noatext - mbrgen  ; no active partition
  call printmsg
  int BIOSBASICINT                  ; call BASIC or other bootstrap loader
  JMPS .bad                         ; reboot in case it returned
.tn:
  cmp [bx], ch     ; ch = 0
  je .af           ; ok, no multiple partitions marked active, no garbage
.bad:
  mov si, RELOC + badtext - mbrgen  ; bad partition table --
  JMPS errorgen                     ; report and reboot
.af:
  add bx, byte 16
  loop .tn         ; continue searching


; Boot from selected HD partition or other device.
; On entry:
;   dl = boot drive number
;   si = active partition data
;   cx = 0

execbootgen:
  mov bx, LOADADR
  push si             ; si needed temporarily...
  lodsw
  mov dh, ah          ; partition start head
  push si             ; si needed temporarily...
  push es             ; LBA address packet on the stack: 0,
  push es             ;   0,
  mov di, [si + 8]
  push di             ;   LBA sector hi,
  push word [si + 6]  ;   LBA sector lo: qword sector
  push es
  push bx             ; buffer segment:offset
; mov cx, 1
  inc cx
  push cx             ; number of sectors
  mov cl, 16
  push cx             ; packet size
  mov si, sp          ; ds:si = LBA address packet (ss = ds)
  mov ah, 42h
  int BIOSDISKINT     ; extended disk read
  lea sp, [si + 16]   ; clean the stack
  pop si              ; restore partition pointer
  jnb runbootgen      ; success
  xchg ax, di
  test ah, ah
  jne booterrgen      ; sector number > 0ffffffh, cannot use CHS
  mov cx, [si]        ; partition start cylinder/sector
  mov di, 3           ; retry count
.retry:
  mov ax, 201h
  int BIOSDISKINT  ; read 1 sector, CHS
  jnb runbootgen   ; no error
  xor ax, ax
  int BIOSDISKINT  ; reset drive
  dec di
  jne .retry       ; try once more?


; Signal boot error and re-start.

booterrgen:
  mov si, RELOC + errtext - mbrgen


; Signal an error and re-start.

errorgen:
  call printmsg                    ; first part of the message (variable)
  mov si, RELOC + rebtext - mbrgen ; second part of the message (fixed)
  call printmsg
  xor ax, ax
  int BIOSKEYBINT                  ; wait for a key press
  int BIOSBOOTINT                  ; reboot


; Run the partition boot loader from its first sector.
; The loader is called with: dl = drive number, dh = 0 (int 13h device),
; ds:si still points to partition data at 7beh, 7ceh, 7deh or 7eeh,
; as in standard DOS loaders (for maximum compatibility), es:bx = 0:7c00h.

runbootgen:
  cmp word [LOADADR + PARTSIGN], ISVALIDPART  ; check if a valid
  jne booterrgen                              ;   bootable partition
  mov si, RELOC + oktext - mbrgen
  call printmsg                               ; print `Ok.'
  pop si                                      ; ds:si = partition info
  xor dh, dh
.ret:
  ret  ; run boot code (0:7c00h)


; Print message (ASCII terminated with bit 7 set).
; On entry:
;   ds:si = message
; On exit:
;   ds:si = character past the message
;   all registers but bx, cx, dx possibly destroyed

printmsg:
  push bx  ; save register
.nxt:
  lodsb             ; get next character
  push ax           ; save character
  and al, 7fh       ; mask out bit 7
  mov ah, 0eh
  push si           ; old BIOSes corrupt ax, bx, si, di, bp (?)
  xor bx, bx        ; page 0
  int BIOSVIDEOINT  ; print character
  pop si
  pop ax
  test al, al
  jns .nxt          ; bit 7 set terminates message
  pop bx
  ret

inittext: Db 'HD'
.hd:      Db '1' - 80h, ':', ' ' + 80h
oktext:   Db 'Ok. Booting.', 13, 10 + 80h
noatext:  Db 'No active partition!', 10, 13 + 80h
badtext:  Db 'Bad partition table!', ' ' + 80h
errtext:  Db 'OS load error!', ' ' + 80h
rebtext:  Db 7, 'Any key to reboot...', 13, 10 + 80h

  Db ' GMBLDR Version 18-FEB-2005 - generic Master Bootstrap Loader '
  Db ' Copyright (c) 1997-2005 BTTR Software '

  Times (NTVOLBYTES - ($ - mbrgen))  Db 0  ; filler to 512 bytes

; end of BOOTLDR area (offset 1b8h)

%ifndef VERSIONDATE  ; only in MBR image file

  Db 0, 0, 0, 0        ; reserved for NT Volume Bytes
  Dw 0                 ; reserved
  Times (4 * 16) Db 0  ; empty partition table
  Dw ISVALIDPART       ; valid partition table signature

%endif

; (end of generic.asm)
