; ****************************************************************************
; `defs' - common equates and macros
;   Written by Michal H. Tyc
;
; This file is part of `BOOTMGR - multi-BOOT ManaGeR'.
;
; Copyright (c) 1997-2006 BTTR Software.  All rights reserved.
;
; This program is free software; you can redistribute it and/or modify it
; under the terms of the `MODIFIED' BSD LICENSE.  Please see `legal.txt'
; for details.
; ****************************************************************************


; Interrupts.

BIOSVIDEOINT  Equ 10h
BIOSDISKINT   Equ 13h
BIOSKEYBINT   Equ 16h
BIOSBASICINT  Equ 18h
BIOSBOOTINT   Equ 19h
DOSTERMINT    Equ 20h
DOSINT        Equ 21h
MUXINT        Equ 2fh

; Partition table layout.

NTVOLBYTES  Equ 1b8h
PARTTABL    Equ 1beh
PARTSIGN    Equ 1feh
ISVALIDPART Equ 0aa55h

; `Pointers' of floppy and other HD MBRs.

FLOPPYID Equ 0
OTHERID  Equ 1

; a handy shortcut for short jump
%define JMPS jmp short

; offset in frame buffer (80-column text modes)
%define SCROFS(x, y) (160 * (y) + 2 * (x))

; coordinates (row:col), box size (height:width)
%define SCRCRD(x, y) (((y) << 8) + (x))

; Program configuration.

NITEMS Equ 5            ; maximum number of items in boot menu
CITEMS Equ 2            ; default number of items
DEFIT  Equ 0            ; default item
DEFTIM Equ 10           ; timeout
CFGLEN Equ NITEMS * 10  ; size of configuration area at the end of boot loader

; Master Bootstrap Loader load and relocation addresses

LOADADR Equ 7c00h
RELOC   Equ 600h

; (end of defs.inc)
