#include <rtos.h>
#include <conio.h>
#include <dos.h>

/*
 * mouse_init - returns 0 if no mouse installed
 */

int mouse_init( void )
{
    asm {
        xor     ax, ax
        int     0x33
    }
    return( _AX );
}

/*
 * mouse_show - 1 if visible, 0 if invisible
 */
void mouse_show( int data )
{
    if (data)
        _AX = 1;
    else
        _AX = 2;
    asm int 0x33
}

/*
 * mouse_posn - return X, Y posn and button status
 */
void mouse_posn( int *x, int *y, int *buttons )
{
    int a, b, c;
    asm {
        mov     ax, 3
        int     0x33
        mov     a, cx
        mov     b, dx
        mov     c, bx
    }
    *x = a;
    *y = b;
    *buttons = c;
}

