/*
 * eRTOS SNMP Sample
 *
 * Most eRTOS SNMP applications use static tables to hold the MIBs
 * This simple example shows how to accomplish that.  Even though
 * the table is static, the data can be dynamic, as is shown in my_fn
 *
 * For a dynamic SNMP MIB table, see snmp_d_2.c
 *
 * You will need an SNMP client to test this program.
 * Excellent free SNMP clients can be found at ucd-snmp.ucdavis.edu
 *  eg. snmpwalk  hostname  public
 *          will display all SNMP variables found on hostname
 *      snmpset hostname public system.sysDesc.0 s hi
 *          will faile because 1.3.6.1.2.1.1.0 is readonly
 *      snmpset hostname public system.sysUpTime.0 i 200
 *          will successfully (temporarily) set the uptime to 2 seconds
 */

#include <stdio.h>
#include <string.h>
#include <snmp.h>
#include <rtos.h>
#include <net.h>
/*
 * Sample SNMP exensible function
 *
 * Note: we are passed data1 and data2 parameters from our esnmp_oid structure
 *       this can be used (as shown) to use one function for many different
 *       snmp OID entries
 */
/* following pragma removes unnecessary warning */
#pragma argsused
long my_fn( udp_Socket *udp, char *community, int op, SNMP_OBJECT *reply, DWORD data1, DWORD data2 )
{
    /* must use community string PUBLIC */
    if ( stricmp( community, "PUBLIC" ))
        return( SNMP_GENERROR );

    switch ( data1 ) {
        case    1 : /* this attribute is readonly */
                    if ( op == SNMP_PDU_SET )
                        return( SNMP_READONLY );

                    /* it is a GET or NEXT request */
                    reply->Type = SNMP_OCTETSTR;
                    strcpy( reply->Syntax.BufChr, (char *)data2 );
                    reply->SyntaxLen = strlen( (char*)data2 );
                    return( 0 );

        case    2 : if ( op == SNMP_PDU_SET ) {
                        /* a successful set returns the new value */
                        data2 = reply->Syntax.LngInt;
                    }

                    reply->Type = SNMP_TIMETICKS;
                    reply->Syntax.LngInt = data2;
                    return( 0 );
    }
}

esnmp_oid far local_oids[] =
      /* the first two examples use a client function to return results */
      /* note: we pass the client function some user-defined parameters */
    { { 0,{1,3,6,1,2,1,1,1,0, -1}, my_fn, 1, (DWORD)"eRTOS example" },
      { 0,{1,3,6,1,2,1,1,3,0, -1}, my_fn, 2, 1 },

      /* next example does not use a client function, uses built-in reply */
      { 0,{1,3,6,1,2,1,1,4,0, -1}, NULL, SNMP_DISPLAYSTR, (DWORD)"Contact: joe" },

      /* return a pointer to an OID */
      { 0,{1,3,6,1,2,1,1,5,0, -1}, NULL, SNMP_OBJECTID, (DWORD)"1.3.6.1.3" },
      /* list terminator */
      { 0,{ -1 }, NULL, 0, 0 }
      };


void main(int argc, char **argv)
{
    kdebug = 1;
    rt_init( 100 );
    sock_init();

    snmp_compile_oids( local_oids );

    rt_newthread( snmpthread,  1,2048, 0, "snmpd" );

    while (1) {
        rt_sleep(1000);
    }
}

