/*
 *    SPEED - by Shawn Hargreaves, 1999
 *
 *    Global defines.
 */

#ifndef __SPEED_H__
#define __SPEED_H__


/* global state variables */
extern int cheat;
extern int low_detail;
extern int no_grid;
extern int score;
extern int lives;


/* from title.c */
int title_screen();
void show_results();
void goodbye();


/* from view.c */
void init_view();
void shutdown_view();
int advance_view();
void update_view();
void draw_view(BITMAP *bmp);
float view_size();


/* from player.c */
void init_player();
void shutdown_player();
void advance_player(int cycle);
int update_player();
void draw_player(BITMAP *bmp, int r, int g, int b, int (*project)(float *f, int *i, int c));
float player_pos();
float find_target(float x);
int player_dying();
void kill_player(float x);


/* from badguys.c */
void init_badguys();
void shutdown_badguys();
int update_badguys();
void draw_badguys(BITMAP *bmp, int r, int g, int b, int (*project)(float *f, int *i, int c));
void lay_attack_wave(int reset);


/* from bullets.c */
void init_bullets();
void shutdown_bullets();
void update_bullets();
void draw_bullets(BITMAP *bmp, int r, int g, int b, int (*project)(float *f, int *i, int c));
void fire_bullet();
void *get_first_bullet(float *x, float *y);
void *get_next_bullet(void *b, float *x, float *y);
void kill_bullet(void *b);


/* from explode.c */
void init_explode();
void shutdown_explode();
void update_explode();
void draw_explode(BITMAP *bmp, int r, int g, int b, int (*project)(float *f, int *i, int c));
void explode(float x, float y, int big);


/* from message.c */
void init_message();
void shutdown_message();
void update_message();
void draw_message(BITMAP *bmp);
void message(char *text);



#endif   /* __SPEED_H__ */
