#include "kernel.h"
/////////////////////////////////////////////////////////////////////////////
PFileDriver MsDosFileDriver;
//
l_ulong MsDosTimeConvert( unsigned short date, unsigned short time )
{
   struct tm t;
   //
   memset( &t, 0, sizeof( t ) );
   t.tm_hour = ( time >> 11 ) & 0x1f;
   t.tm_min = ( time >> 5 ) & 0x3f;
   t.tm_sec = ( time & 0x1f ) * 2;
   t.tm_mon = ( date >> 5 ) & 0x0f;
   t.tm_mday = ( date & 0x1f );
   t.tm_year = ( ( date >> 9 ) & 0x7f ) + 80;
   //
   return mktime( &t );
}
////////////////////////////////////////////////////////////////////////////////
PFile MsDosFileOpen ( PDrive d, l_text File, l_text Mode )
{
   PFile o = malloc( sizeof( TFile ) );
   l_text RF = NULL;
   //
   if ( !o )
      return NULL;
   memset( o, 0, sizeof( TFile ) );
   RF = FileNameToPath( d->Ex1, File );
   DebugMessage( "Try to open %s...", RF );
   o->Ex1 = fopen( RF, Mode );
   if ( !o->Ex1 )
   {
      free( o );
	  free( RF );
	  DebugWarning("\tOpen Failed");
	  //
      return NULL;
   }
   o->FileSize = filelength( fileno( ( FILE* )o->Ex1 ) );
   o->Drive = d;
   //
   return o;
}
////////////////////////////////////////////////////////////////////////////////
void MsDosFileClose ( PFile f )
{
   fclose( ( FILE* )f->Ex1 );
   free( f );
}
////////////////////////////////////////////////////////////////////////////////
l_int MsDosFileRead ( PFile f, void *d, l_ulong s )
{
   return fread( d, 1, s, ( FILE* )f->Ex1 );
}
////////////////////////////////////////////////////////////////////////////////
l_int MsDosFileWrite ( PFile f, void *d, l_ulong s )
{
   return fwrite( d, 1, s, ( FILE* )f->Ex1 );
}
////////////////////////////////////////////////////////////////////////////////
l_int MsDosFileEOF ( PFile f )
{
   return feof( ( FILE* )f->Ex1 );
}
////////////////////////////////////////////////////////////////////////////////
l_int MsDosFileGetPos ( PFile f, l_ulong *Pos )
{
   return fgetpos( ( FILE* )f->Ex1, Pos );
}
////////////////////////////////////////////////////////////////////////////////
l_int MsDosFileSeek ( PFile f, l_int Type, l_long Pos )
{
   return fseek( ( FILE* )f->Ex1, Pos, Type );
}
////////////////////////////////////////////////////////////////////////////////
l_bool MsDosFileDelete ( PDrive d, l_text File )
{
   l_text RF = FileNameToPath( d->Ex1, File );
   l_bool r = false;
   //
   if ( RF )
   {
      if ( remove( RF ) )
         r = true;
      free( RF );
   }
   //
   return r;
}
////////////////////////////////////////////////////////////////////////////////
l_bool MsDosFileRename ( PDrive d, l_text File, l_text NewName )
{
   l_text RF1 = FileNameToPath( d->Ex1, File );
   l_text RF2 = FileNameToPath( d->Ex1, NewName );
   l_bool r = false;
   //
   if ( !RF1 || !RF2 )
      return false;
   if ( !rename( RF1, RF2 ) )
      r = true;
   free( RF1 ); free( RF2 );
   //
   return r;
}
////////////////////////////////////////////////////////////////////////////////
PFileInfo MsDosFileGetInfo ( PDrive d, l_text VFile, l_text File )
{
   if ( !*File )
   {
      PFileInfo i = malloc( sizeof( TFileInfo ) );
      //
      memset( i, 0, sizeof( TFileInfo ) );
      i->Name = TextDup( d->Name );
	  i->VPathName = TextDup( VFile );
      i->LocalName = TextDup( File );
      i->Attributes = FA_DIREC|FA_LABEL|FA_RDONLY;
      i->Type = d->Type;
      i->Size = d->TotalSpace;
      i->Drive = d;
      //
      return i;
   }
   else
   {
      l_text RF = FileNameToPath( d->Ex1, File );
	  struct ffblk ff;
	  //
	  if ( !findfirst( RF, &ff, FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_LABEL|FA_DIREC|FA_ARCH ) )
	  {
		 PFileInfo i = malloc( sizeof( TFileInfo ) );
		 //
		 memset( i, 0, sizeof( TFileInfo ) );
		 i->Name = TextDup( ff.ff_name );
		 i->VPathName = TextDup( VFile );
         i->LocalName = TextDup( File );
         i->Attributes = ff.ff_attrib;
         if ( i->Attributes & FA_DIREC )
            i->Type = FT_FOLDER;
         else
            i->Type = FT_FILE;
         i->MTime = MsDosTimeConvert( ff.ff_fdate, ff.ff_ftime );
         i->CTime = MsDosTimeConvert( ff.lfn_cdate, ff.lfn_ctime );
         i->ATime = MsDosTimeConvert( ff.lfn_adate, ff.lfn_atime );
         i->Size = ff.ff_fsize;
         i->Drive = d;
         //
         return i;
	  }
	  //
	  return NULL;
   }
   //
   return NULL;
}
////////////////////////////////////////////////////////////////////////////////
l_int MsDosFileLength ( PFile f )
{
   f->FileSize = filelength( fileno( ( FILE* )f->Ex1 ) );
   //
   return f->FileSize;
}
////////////////////////////////////////////////////////////////////////////////
l_int MsDosFileFlush ( PFile f )
{
   return fflush( ( FILE* )f->Ex1 );
}
////////////////////////////////////////////////////////////////////////////////
l_bool MsDosDirMake ( PDrive d, l_text Dir )
{
   l_text RF = FileNameToPath( d->Ex1, Dir );
   l_bool r = false;
   //
   if ( RF )
   {
	  if ( mkdir( RF, S_IWUSR ) )
		 r = true;
	  free( RF );
   }
   //
   return r;
}
////////////////////////////////////////////////////////////////////////////////
l_bool MsDosDirDelete ( PDrive d, l_text Dir )
{
   l_text RF = FileNameToPath( d->Ex1, Dir );
   l_bool r = false;
   //
   if ( RF )
   {
	  if ( rmdir( RF ) )
		 r = true;
	  free( RF );
   }
   //
   return r;
}
////////////////////////////////////////////////////////////////////////////////
PList MsDosList ( PDrive d, l_text VDir, l_text Dir, l_uchar Attrib )
{
   PList l = NewList();
   PFileInfo i;
   l_text RF0, RF;
   struct ffblk ff;
   l_int r, s = TextLen( Dir );
   //
   RF0 = FileNameToPath( d->Ex1, Dir );
   RF = FileNameToPath( RF0, "*.*" );
   free( RF0 );
   r = findfirst( RF, &ff, Attrib );
   while ( !r )
   {
	  i = malloc( sizeof( TFileInfo ) );
	  memset( i, 0, sizeof( TFileInfo ) );
	  if ( TextCompare( ff.ff_name, "." ) && TextCompare( ff.ff_name, ".." ) )
	  {
		 i->Name = TextDup( ff.ff_name );
		 i->VPathName = FileNameToPath( VDir, i->Name );
		 i->LocalName = *Dir ? FileNameToPath( Dir, i->Name ) : TextDup( i->Name );
		 i->Attributes = ff.ff_attrib;
		 if ( i->Attributes & FA_DIREC )
			i->Type = FT_FOLDER;
		 else
			i->Type = FT_FILE;
		 i->MTime = MsDosTimeConvert( ff.ff_fdate, ff.ff_ftime );
		 i->CTime = MsDosTimeConvert( ff.lfn_cdate, ff.lfn_ctime );
		 i->ATime = MsDosTimeConvert( ff.lfn_adate, ff.lfn_atime );
		 i->Size = ff.ff_fsize;
		 i->Drive = d;
		 ListAdd( l, ff.ff_name, i, ( void* )&FreeFileInfo );
	  }
	  r = findnext( &ff );
   }
   free( RF );
   //
   return l;
}
////////////////////////////////////////////////////////////////////////////////
l_bool MsDosFileSetAttributes ( PDrive d, l_text File, l_uchar Attrib )
{
   l_text RF = FileNameToPath( d->Ex1, File );
   l_bool r = false;
   //
   if ( RF )
   {
	  if ( _chmod( RF, 1, Attrib ) )
		 r = true;
	  free( RF );
   }
   //
   return r;
}
////////////////////////////////////////////////////////////////////////////////
void InitMsDosFileDriver ( void )
{
   MsDosFileDriver = malloc( sizeof( TFileDriver ) );
   MsDosFileDriver->DriverName = TextDup( "WinDos I/O to MS I/O layer driver" );
   MsDosFileDriver->FileOpen = &MsDosFileOpen;
   MsDosFileDriver->FileClose = &MsDosFileClose;
   MsDosFileDriver->FileRead = &MsDosFileRead;
   MsDosFileDriver->FileWrite = &MsDosFileWrite;
   MsDosFileDriver->FileGetPos = &MsDosFileGetPos;
   MsDosFileDriver->FileSeek = &MsDosFileSeek;
   MsDosFileDriver->FileDelete = &MsDosFileDelete;
   MsDosFileDriver->FileRename = &MsDosFileRename;
   MsDosFileDriver->FileGetInfo = &MsDosFileGetInfo;
   MsDosFileDriver->FileFlush = &MsDosFileFlush;
   MsDosFileDriver->DirMake = &MsDosDirMake;
   MsDosFileDriver->DirDelete = &MsDosDirDelete;
   MsDosFileDriver->DirRename = &MsDosFileRename;
   MsDosFileDriver->List = &MsDosList;
   MsDosFileDriver->FileSetAttributes = &MsDosFileSetAttributes;
   MsDosFileDriver->FileEOF = &MsDosFileEOF;
   MsDosFileDriver->RefreshDriveInfo = NULL;
   //
   DebugMessage( "MsDosFileDriver=0x%X", MsDosFileDriver );
}
