#ifndef JPEG_H
   #define JPEG_H
   #define JPEG_VERSION             1
   #define JPEG_SUB_VERSION         0
   #define JPEG_REVISION            3
   #define JPEG_DESC                "jpeg library v1.03 based on IJG v6.0a"
   #define JPEG_AUTHOR              "Eric Vannier as known as Fweibuli"
   #ifndef ALLEGRO_H
      #include <allegro.h>
   #endif 
   #ifdef __cplusplus
      extern "C" 
      {
      #endif
      #define DEFAULT_QUALITY          75
      typedef enum 
      {
         CT_RGB, 
         CT_GRAYSCALE
      } color_type_t;
      typedef enum 
      {
         DS_SLOW, 
         DS_FAST
      } decoding_speed_t;
      typedef struct 
      {
         int quality; 
         color_type_t color_type; 
      } jpeg_code_param ;
      typedef struct 
      {
         color_type_t color_type; 
         int scale_factor; 
         decoding_speed_t decoding_speed;
         unsigned int first_color; 
         unsigned int nbr_colors; 
      } jpeg_decode_param;
      BITMAP *load_jpeg_ex( char *filename, RGB *pal, jpeg_decode_param *jpeg );
      BITMAP *load_jpeg( char *filename, RGB *pal );
      int save_jpeg_ex( char *filename, BITMAP *bmp, RGB *pal, jpeg_code_param *jpeg );
      int save_jpeg( char *filename, BITMAP *bmp, RGB *pal );
      #ifdef __cplusplus
      }
   #endif
#endif 
