#define DMS2
#include "windos.h"
#include "algbm.h"
#include "ico.h"
#include "jpeg.h"
//
l_ulong AppVersion = ULONG_ID(0,0,0,1);
char    AppName[] = "Images loaders/savers";
l_uid	nUID = "";
//
typedef struct t_point
{
   long x;
   long y;
} t_point;
//
typedef struct t_cursor *p_cursor;
typedef struct t_cursor
{
   BITMAP *bmp;
   struct t_point focus;
} t_cursor;
//
typedef unsigned short WORD;
typedef unsigned char BYTE;
typedef long LONG;
typedef unsigned long DWORD;
typedef struct tagRGBQUAD
{
   BYTE rgbBlue;
   BYTE rgbGreen;
   BYTE rgbRed;
   BYTE rgbReserved;
}
RGBQUAD;
typedef struct tagBITMAPINFOHEADER 
{
   DWORD biSize;
   LONG biWidth;
   LONG biHeight;
   WORD biPlanes;
   WORD biBitCount;
   DWORD biCompression;
   DWORD biSizeImage;
   LONG biXPelsPerMeter;
   LONG biYPelsPerMeter;
   DWORD biClrUsed;
   DWORD biClrImportant;
}
BITMAPINFOHEADER;
typedef struct
{
   BYTE bWidth;
   BYTE bHeight;
   BYTE bColorCount;
   BYTE bReserved;
   WORD wPlanes;
   WORD wBitCount;
   DWORD dwBytesInRes;
   DWORD dwImageOffset;
}
ICONDIRENTRY, *LPICONDIRENTRY;
typedef struct
{
   WORD idReserved;
   WORD idType;
   WORD idCount;
   ICONDIRENTRY idEntries[ 1 ];
}
ICONDIR, *LPICONDIR;
typedef struct _CURSORDIRENTRY 
{
   BYTE bWidth;
   BYTE bHeight;
   BYTE bColorCount;
   BYTE bReserved;
   WORD wXHotspot;
   WORD wYHotspot;
   DWORD lBytesInRes;
   DWORD dwImageOffset;
}
CURSORDIRENTRY;
typedef struct _CURSORDIR 
{
   WORD cdReserved;
   WORD cdType;
   WORD cdCount;
   CURSORDIRENTRY cdEntries[ 1 ];
}
CURSORDIR;
/* -------------------------------------------------------------------------*/
BITMAP *resize_to_bmp ( BITMAP *bmp, int  w, int  h )
{
   if ( bmp && w > 0 && h > 0 )
   {
	  BITMAP *o = create_bitmap( w, h );
      clear_to_color( o, o->vtable->mask_color );
      if ( !o )
         return NULL;
	  stretch_blit( bmp, o, 0, 0, bmp->w, bmp->h, 0, 0, o->w, o->h );
      // aa_stretch_sprite( o, bmp, 0, 0, w, h );
      return o;
   }
   return NULL;
}
/* -------------------------------------------------------------------------*/
BITMAP *resizebmp( BITMAP *bmp, int  w, int  h )
{
   BITMAP *o = resize_to_bmp( bmp, w, h );
   if ( !o )
      return bmp;
   destroy_bitmap( bmp );
   //
   return o;
}
long mgetl( void *data )
{
   int b1=0, b2=0, b3=0, b4=0;
   //
   memcpy( &b1, data, 1 );
   memcpy( &b2, data+1, 1 );
   memcpy( &b3, data+2, 1 );
   memcpy( &b4, data+3, 1 );
   //
   return ( ( ( long )b1 << 24 ) | ( ( long )b2 << 16 ) | ( ( long )b3 << 8 ) | ( long )b4 );
}
BITMAP *ico2bmp( FILE *f, WORD Width, WORD Height, DWORD Offset, DWORD Bytes )
{
   BITMAP *bmp;
   BITMAPINFOHEADER *icHeader;
   RGBQUAD *cols;
   void *data;
   int  pos=0, l=0, c, bpp;
   BYTE sr, sg, sb;
   //
   if ( !f )
	  return NULL;
   fsetpos( f, &Offset );
   data = malloc( Bytes );
   fread( data, Bytes, 1, f );
   icHeader = data+pos;
   pos+=sizeof( BITMAPINFOHEADER );
   if ( !Width || !Height )
   {
	  Width = icHeader->biWidth;
	  Height = icHeader->biHeight;
   }
   ;
   if ( !Width || !Height )
	  return NULL;
   bpp = icHeader->biBitCount;
//   DebugMessage("Ico2Bmp Bpp=<%d> Width=<%d> Height=<%d>",bpp,Width,Height);
   bmp = create_bitmap( Width, Height );
   if ( !bmp )
	  return NULL;
   //
   sr=getr( bmp->vtable->mask_color );
   sg=getg( bmp->vtable->mask_color );
   sb=getb( bmp->vtable->mask_color );
   if ( bpp == 24 )
   {
	  l=0;
	  while( l < Height )
	  {
		 c=0;
		 while( c < Width )
		 {
			unsigned char r, g, b;
			memcpy( &r, data+pos, 1 );
			pos+=1;
			memcpy( &g, data+pos, 1 );
			pos+=1;
			memcpy( &b, data+pos, 1 );
			pos+=1;
			if ( r ==sr && g ==sg && b==sb )
			   g+=36;
            putpixel( bmp, c, Height-1-l, makecol( r, g, b ) );
            c++;
         }
		 ;
		 l++;
	  }
	  ;
   }
   else
   {
	  cols=data+pos;
	  pos+=sizeof( RGBQUAD ) * ( 1<<bpp );
	  l=0;
	  if ( cols )
	  {
		 int a = 0;
		 while( a < 1<<bpp )
		 {
			if ( cols[ a ].rgbRed==sr && cols[ a ].rgbGreen==sg && cols[ a ].rgbBlue==sb )
			{
			   cols[ a ].rgbGreen+=36;
			}
			;
			a++;
		 }
		 ;
	  }
	  ;
	  while( l < Height )
	  {
		 unsigned char b[ 40 ];
		 c=0;
		 while( c < Width )
		 {
			if ( bpp == 8 )
			{
			   unsigned char nc = 0;
			   memcpy( &nc, data+pos, 1 );
			   pos+=1;
			   putpixel( bmp, c, Height-1-l, makecol( cols[ nc ].rgbRed, cols[ nc ].rgbGreen, cols[ nc ].rgbBlue ) );
            }
            else if ( bpp == 16 ) 
            {
               unsigned short nc;
			   memcpy( &nc, data+pos, 2 );
               pos+=2;
               putpixel( bmp, c, Height-1-l, makecol( cols[ nc ].rgbRed, cols[ nc ].rgbGreen, cols[ nc ].rgbBlue ) );
			}
			else if ( bpp == 4 )
            {
			   unsigned long n;
			   int j, k;
			   int temp;
               int nc;
			   //
			   j = c % 8;
			   if ( j == 0 )
			   {
				  memcpy( &n, data+pos, 4 );
				  pos+=4;
				  for ( k=0;
					 k<4;
				  k++ )
				  {
					 temp = n & 255;
					 b[ k*2+1 ] = temp & 15;
					 temp = temp >> 4;
					 b[ k*2 ] = temp & 15;
					 n = n >> 8;
				  }
			   }
			   nc = b[ j ];
			   putpixel( bmp, c, Height-1-l, makecol( cols[ nc ].rgbRed, cols[ nc ].rgbGreen, cols[ nc ].rgbBlue ) );
			}
			else if ( bpp == 1 )
			{
			   unsigned long n;
               int j, k;
               int nc;
			   j = c % 32;
               if ( j == 0 ) 
               {
                  n = mgetl( data+pos );
                  pos+=4;
				  for ( k=0;
					 k<32;
                  k++ ) 
				  {
					 b[ 31-k ] = ( char )( n & 1 );
                     n = n >> 1;
				  }
			   }
               nc = b[ j ];
               putpixel( bmp, c, Height-1-l, makecol( cols[ nc ].rgbRed, cols[ nc ].rgbGreen, cols[ nc ].rgbBlue ) );
            }
			;
			c++;
         }
		 ;
         l++;
      }
      ;
   }
   ;
   l=0;
   while( l < Height )
   {
	  unsigned char b[ 40 ];
	  unsigned long n;
	  int i, j, k;
	  int pix;
	  for ( i=0; i<Width; i++ )
	  {
		 j = i % 32;
		 if ( j == 0 )
		 {
			n = mgetl( data+pos );
			pos+=4;
			for ( k=0;
			   k<32;
			k++ )
			{
			   b[ 31-k ] = ( char )( n & 1 );
			   n = n >> 1;
			}
		 }
		 pix = b[ j ];
		 if ( pix )
			putpixel( bmp, i, Height-1-l, bmp->vtable->mask_color );
	  }
	  l++;
   }
   ;
   free( data );
   //
   return bmp;
}
;
BITMAP *_load_ico ( FILE *f )
{
   ICONDIR *pIconDir = ( ICONDIR* )malloc( sizeof( ICONDIR ) );
   int  i = 0;
   //
   fread( &( pIconDir->idReserved ), sizeof( WORD ), 1, f );
   fread( &( pIconDir->idType ), sizeof( WORD ), 1, f );
   fread( &( pIconDir->idCount ), sizeof( WORD ), 1, f );
   pIconDir = ( ICONDIR* )realloc( pIconDir, ( sizeof( WORD ) * 3 ) + ( sizeof( ICONDIRENTRY ) * pIconDir->idCount ) );
   fread( &( pIconDir->idEntries ), pIconDir->idCount * sizeof( ICONDIRENTRY ), 1, f );
   for ( i=0; i<pIconDir->idCount; i++ )
   {
//	  if ( pIconDir->idEntries[ i ].bWidth == wsize && pIconDir->idEntries[ i ].bColorCount == dep )
	  {
		 return ico2bmp( f , pIconDir->idEntries[ i ].bWidth, pIconDir->idEntries[ i ].bHeight, pIconDir->idEntries[ i ].dwImageOffset, pIconDir->idEntries[ i ].dwBytesInRes );
	  }
   }
   for ( i=0; i<pIconDir->idCount; i++ ) 
   {
//	  if ( pIconDir->idEntries[ i ].bWidth == wsize )
	  {
		 return ico2bmp ( f, pIconDir->idEntries[ i ].bWidth, pIconDir->idEntries[ i ].bHeight, pIconDir->idEntries[ i ].dwImageOffset, pIconDir->idEntries[ i ].dwBytesInRes );
	  }
	  ;
   }
   for ( i=0; i<pIconDir->idCount; i++ ) 
   {
//	  if ( pIconDir->idEntries[ i ].bColorCount == dep )
	  {
		 BITMAP *bmp = ico2bmp ( f, pIconDir->idEntries[ i ].bWidth, pIconDir->idEntries[ i ].bHeight, pIconDir->idEntries[ i ].dwImageOffset, pIconDir->idEntries[ i ].dwBytesInRes );
		 //
		 return resizebmp( bmp, pIconDir->idEntries[ i ].bWidth, pIconDir->idEntries[ i ].bWidth );
      }
      ;
   }
   if ( pIconDir->idCount ) 
   {
	  BITMAP *bmp = ico2bmp ( f, pIconDir->idEntries[ 0 ].bWidth,
	  pIconDir->idEntries[ 0 ].bHeight,
      pIconDir->idEntries[ 0 ].dwImageOffset, 
	  pIconDir->idEntries[ 0 ].dwBytesInRes );
	  //
	  return resizebmp( bmp, pIconDir->idEntries[ i ].bWidth, pIconDir->idEntries[ i ].bWidth );
   }
   ;
   free( pIconDir );
   //
   return NULL;
}
;
BITMAP *load_ico ( char * file )
{
   if ( file )//&& wsize > 0 && wdepth > 0 )
   {
	  FILE* f = fopen( file, "rb" );
	  BITMAP *bmp;
	  //
	  if ( !f )
		 return NULL;
	  bmp = _load_ico( f );
	  fclose( f );
	  //
      return bmp;
   }
   //
   return NULL;
}
/****************************************************************************/
BITMAP *load_cur( char * file )
{
   if ( file )
   {
	  FILE* f = fopen( file, "rb" );
	  CURSORDIR *pCursorDir = ( CURSORDIR* )malloc( sizeof( CURSORDIR ) );
	  BITMAP *bmp;
	  //
	  if ( !f || !pCursorDir )
	  {
		 free( pCursorDir );
		 fclose(f);
		 return;
	  }
	  fread( &( pCursorDir->cdReserved ), sizeof( WORD ), 1, f );
	  fread( &( pCursorDir->cdType ), sizeof( WORD ), 1, f );
	  fread( &( pCursorDir->cdCount ), sizeof( WORD ), 1, f );
	  pCursorDir = /*realloc*/( CURSORDIR* )realloc( pCursorDir, ( sizeof( WORD ) * 3 ) + ( sizeof( CURSORDIRENTRY ) * pCursorDir->cdCount ) );
	  fread( &( pCursorDir->cdEntries ), pCursorDir->cdCount * sizeof( CURSORDIRENTRY ), 1, f );
	  bmp = ico2bmp( f, pCursorDir->cdEntries[ 0 ].bWidth,pCursorDir->cdEntries[ 0 ].bHeight,pCursorDir->cdEntries[ 0 ].dwImageOffset,pCursorDir->cdEntries[ 0 ].lBytesInRes );
	  free( pCursorDir );
	  fclose( f );
	  //
	  return bmp;
   }
   ;
   //
   return NULL;
}
/****************************************************************************/
void LoadMouseFocusFromFile( char * file, l_ushort *sx, l_ushort *sy )
{
   if ( file )
   {
	  p_cursor cur;
	  FILE* f = fopen( RealFileName( file ), "rb" );
	  CURSORDIR *pCursorDir = ( CURSORDIR* )malloc( sizeof( CURSORDIR ) );
	  //
	  if ( !f || !pCursorDir )
	  {
		 free( pCursorDir );
		 fclose(f);
		 return;
	  }
	  ;
	  cur = ( p_cursor )malloc( sizeof( t_cursor ) );
	  if (!cur)
	  {
		 free( pCursorDir );
		 fclose(f);
		 return;
	  }
	  memset( cur, 0, sizeof( t_cursor ) );
	  fread( &( pCursorDir->cdReserved ), sizeof( WORD ), 1, f );
	  fread( &( pCursorDir->cdType ), sizeof( WORD ), 1, f );
	  fread( &( pCursorDir->cdCount ), sizeof( WORD ), 1, f );
	  pCursorDir = ( CURSORDIR* )realloc( pCursorDir, ( sizeof( WORD ) * 3 ) + ( sizeof( CURSORDIRENTRY ) * pCursorDir->cdCount ) );
	  fread( &( pCursorDir->cdEntries ), pCursorDir->cdCount * sizeof( CURSORDIRENTRY ), 1, f );
	  *(sx) = pCursorDir->cdEntries[ 0 ].wXHotspot;
	  *(sy) = pCursorDir->cdEntries[ 0 ].wYHotspot;
	  free( cur );
	  free( pCursorDir );
	  fclose( f );
   }
   //
   return;
}
;
char * stridup ( char * s, long n )
{
   if ( s && n > 0 )
   {
      char *b = ( char* )malloc( n + 1 );
      //
      if ( b )
      {
		 strncpy( b, s, n );
		 b[ n ] = '\0';
	  }
	  return b;
   }
   //
   return NULL;
}
/****************************************************************************/
BITMAP* LoadIco( AL_CONST char * file )
{
   return load_ico( ( char * )file );
}
/****************************************************************************/
BITMAP *_load_gbm ( AL_CONST char *filename )
{
   return ( BITMAP* )load_gbm( ( char * )filename, 0 );
}
/****************************************************************************/
int _save_gbm ( AL_CONST char *filename, BITMAP *bmp)
{
   return save_gbm( ( char * )filename, bmp, 0 );
}
;
BITMAP *jpeg_load ( AL_CONST char *filename)
{
   return ( BITMAP* )load_jpeg( ( ( char * )filename ), 0 );
}
;
int jpeg_save ( AL_CONST char *filename, BITMAP *bmp)
{
   return save_jpeg( ( ( char * )filename ), bmp, 0 );
}
/****************************************************************************/
l_bool BMPLoadFromFile ( l_text file, l_ptr *Data, l_ulong *Extra, PErrorHandler h )
{
  (*Data) = (void*)load_bitmap(RealFileName(file),0);
  if ( *Data )
		return true;
	else
		return false;
}
/****************************************************************************/
l_bool ICOLoadFromFile ( l_text file, l_ptr *Data, l_ulong *Extra, PErrorHandler h )
{
  (*Data) = (void*)LoadIco(RealFileName(file));
  if ( *Data )
		return true;
	else
		return false;
}
/****************************************************************************/
l_bool IMAGELoadFromFile ( l_text file, l_ptr *Data, l_ulong *Extra, PErrorHandler h )
{
  (*Data) = (void*)_load_gbm(RealFileName(file));
  if ( *Data )
		return true;
	else
		return false;
}
/****************************************************************************/
l_bool JPGLoadFromFile ( l_text file, l_ptr *Data, l_ulong *Extra, PErrorHandler h )
{
  (*Data) = (void*)jpeg_load(RealFileName(file));
  if ( *Data )
		return true;
	else
		return false;
}
/****************************************************************************/
l_bool CURLoadFromFile ( l_text file, l_ptr *Data, l_ulong *Extra, PErrorHandler h )
{
  (*Data) = (void*)load_cur(RealFileName(file));
  if ( *Data )
		return true;
	else
		return false;
}
/****************************************************************************/
PCodec Bmp;
PCodec Ico;
PCodec Gif;
PCodec Tif;
PCodec Vid;
PCodec Pgm;
PCodec Ppm;
PCodec Iax;
PCodec Xbm;
PCodec Pse;
PCodec Jpg;
PCodec Cur;
//
l_bool LibMain ( int argc, l_text *argv )
{
	Bmp = AddCodec("Windows BMP (load OS/2)",ULONG_ID('B','M','P',' '),0,0,0,NULL,"bmp","image/bmp",DTYPE_IMAGE,0 );
	AddSubCodec(Bmp,GenericBinary);
	AddNewSubCodec(Bmp,DTYPE_IMAGE,0,0,&BMPLoadFromFile,0,0,0,0,0,0 );
	//
	Ico = AddCodec("Icono",ULONG_ID('I','C','O',' '),0,0,0,NULL,"ico","image/ico",DTYPE_IMAGE,0 );
	AddSubCodec(Ico,GenericBinary);
	AddNewSubCodec(Ico,DTYPE_IMAGE,0,0,&ICOLoadFromFile,0,0,0,0,0,0 );
	//
	Gif = AddCodec("Gif",ULONG_ID('G','I','F',' '),0,0,0,NULL,"gif","image/gif",DTYPE_IMAGE,0 );
	AddSubCodec(Gif,GenericBinary);
	AddNewSubCodec(Gif,DTYPE_IMAGE,0,0,&IMAGELoadFromFile,0,0,0,0,0,0 );
	//
	Tif = AddCodec("Tif",ULONG_ID('T','I','F',' '),0,0,0,NULL,"tif","image/tif",DTYPE_IMAGE,0 );
	AddSubCodec(Tif,GenericBinary);
	AddNewSubCodec(Tif,DTYPE_IMAGE,0,0,&IMAGELoadFromFile,0,0,0,0,0,0 );
	//
	Vid = AddCodec("Vid",ULONG_ID('V','I','D',' '),0,0,0,NULL,"vid","image/vid",DTYPE_IMAGE,0 );
	AddSubCodec(Vid,GenericBinary);
	AddNewSubCodec(Vid,DTYPE_IMAGE,0,0,&IMAGELoadFromFile,0,0,0,0,0,0 );
	//
	Pgm = AddCodec("Pgm",ULONG_ID('P','G','M',' '),0,0,0,NULL,"pgm","image/pgm",DTYPE_IMAGE,0 );
	AddSubCodec(Pgm,GenericBinary);
	AddNewSubCodec(Pgm,DTYPE_IMAGE,0,0,&IMAGELoadFromFile,0,0,0,0,0,0 );
	//
	Ppm = AddCodec("Ppm",ULONG_ID('P','P','M',' '),0,0,0,NULL,"ppm","image/ppm",DTYPE_IMAGE,0 );
	AddSubCodec(Ppm,GenericBinary);
	AddNewSubCodec(Ppm,DTYPE_IMAGE,0,0,&IMAGELoadFromFile,0,0,0,0,0,0 );
	//
	Iax = AddCodec("Iax",ULONG_ID('I','A','X',' '),0,0,0,NULL,"iax","image/iax",DTYPE_IMAGE,0 );
	AddSubCodec(Iax,GenericBinary);
	AddNewSubCodec(Iax,DTYPE_IMAGE,0,0,&IMAGELoadFromFile,0,0,0,0,0,0 );
	//
	Xbm = AddCodec("Xbm",ULONG_ID('X','B','M',' '),0,0,0,NULL,"xbm","image/xbm",DTYPE_IMAGE,0 );
	AddSubCodec(Xbm,GenericBinary);
	AddNewSubCodec(Xbm,DTYPE_IMAGE,0,0,&IMAGELoadFromFile,0,0,0,0,0,0 );
	//
	Pse = AddCodec("Pse",ULONG_ID('P','S','E',' '),0,0,0,NULL,"pse","image/pse",DTYPE_IMAGE,0 );
	AddSubCodec(Pse,GenericBinary);
	AddNewSubCodec(Pse,DTYPE_IMAGE,0,0,&IMAGELoadFromFile,0,0,0,0,0,0 );
	//
	Jpg = AddCodec("Jpg",ULONG_ID('J','P','G',' '),0,0,0,NULL,"jpg","image/jpg",DTYPE_IMAGE,0 );
	AddSubCodec(Jpg,GenericBinary);
	AddNewSubCodec(Jpg,DTYPE_IMAGE,0,0,&JPGLoadFromFile,0,0,0,0,0,0 );
	//
	Cur = AddCodec("Cur",ULONG_ID('C','U','R',' '),0,0,0,NULL,"cur","image/cur",DTYPE_IMAGE,0 );
	AddSubCodec(Cur,GenericBinary);
	AddNewSubCodec(Cur,DTYPE_IMAGE,0,0,&CURLoadFromFile,0,0,0,0,0,0 );
	//
	APPEXPORT( LoadMouseFocusFromFile );
	//
	return true;
}
/****************************************************************************/
void Close ( void )
{
}
